@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetDevicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDevice.
 * @property deviceId ID of the device.
 * @property globalNetworkId ID of the global network.
 * @property tags Key-value tags for the device.
 */
public data class GetDevicePlainArgs(
    public val deviceId: String,
    public val globalNetworkId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetDevicePlainArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetDevicePlainArgs =
        com.pulumi.aws.networkmanager.inputs.GetDevicePlainArgs.builder()
            .deviceId(deviceId.let({ args0 -> args0 }))
            .globalNetworkId(globalNetworkId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDevicePlainArgs].
 */
@PulumiTagMarker
public class GetDevicePlainArgsBuilder internal constructor() {
    private var deviceId: String? = null

    private var globalNetworkId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the device.
     */
    @JvmName("rsqqdrlodynfirdo")
    public suspend fun deviceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceId = mapped
    }

    /**
     * @param value ID of the global network.
     */
    @JvmName("pftrdmiyrgtphoao")
    public suspend fun globalNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalNetworkId = mapped
    }

    /**
     * @param value Key-value tags for the device.
     */
    @JvmName("fwwhgihgdeguevmg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the device.
     */
    @JvmName("xhrsmnrnhlviyhqw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetDevicePlainArgs = GetDevicePlainArgs(
        deviceId = deviceId ?: throw PulumiNullFieldException("deviceId"),
        globalNetworkId = globalNetworkId ?: throw PulumiNullFieldException("globalNetworkId"),
        tags = tags,
    )
}
