@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetGlobalNetworksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGlobalNetworks.
 * @property tags Restricts the list to the global networks with these tags.
 */
public data class GetGlobalNetworksPlainArgs(
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetGlobalNetworksPlainArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetGlobalNetworksPlainArgs =
        com.pulumi.aws.networkmanager.inputs.GetGlobalNetworksPlainArgs.builder()
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetGlobalNetworksPlainArgs].
 */
@PulumiTagMarker
public class GetGlobalNetworksPlainArgsBuilder internal constructor() {
    private var tags: Map<String, String>? = null

    /**
     * @param value Restricts the list to the global networks with these tags.
     */
    @JvmName("krtlcekkagjgxiod")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Restricts the list to the global networks with these tags.
     */
    @JvmName("gapdclukmcutkcoi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetGlobalNetworksPlainArgs = GetGlobalNetworksPlainArgs(
        tags = tags,
    )
}
