@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetLinksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLinks.
 * @property globalNetworkId ID of the Global Network of the links to retrieve.
 * @property providerName Link provider to retrieve.
 * @property siteId ID of the site of the links to retrieve.
 * @property tags Restricts the list to the links with these tags.
 * @property type Link type to retrieve.
 */
public data class GetLinksPlainArgs(
    public val globalNetworkId: String,
    public val providerName: String? = null,
    public val siteId: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetLinksPlainArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetLinksPlainArgs =
        com.pulumi.aws.networkmanager.inputs.GetLinksPlainArgs.builder()
            .globalNetworkId(globalNetworkId.let({ args0 -> args0 }))
            .providerName(providerName?.let({ args0 -> args0 }))
            .siteId(siteId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLinksPlainArgs].
 */
@PulumiTagMarker
public class GetLinksPlainArgsBuilder internal constructor() {
    private var globalNetworkId: String? = null

    private var providerName: String? = null

    private var siteId: String? = null

    private var tags: Map<String, String>? = null

    private var type: String? = null

    /**
     * @param value ID of the Global Network of the links to retrieve.
     */
    @JvmName("lxvifngfotopwssa")
    public suspend fun globalNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalNetworkId = mapped
    }

    /**
     * @param value Link provider to retrieve.
     */
    @JvmName("hkbonwyqlqtcldcg")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.providerName = mapped
    }

    /**
     * @param value ID of the site of the links to retrieve.
     */
    @JvmName("lqmbpltqwnsuluqr")
    public suspend fun siteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.siteId = mapped
    }

    /**
     * @param value Restricts the list to the links with these tags.
     */
    @JvmName("xsbrmrrdjnhrryyx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Restricts the list to the links with these tags.
     */
    @JvmName("mlruylyxhjnvuijw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Link type to retrieve.
     */
    @JvmName("jppcyomrljercwcr")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetLinksPlainArgs = GetLinksPlainArgs(
        globalNetworkId = globalNetworkId ?: throw PulumiNullFieldException("globalNetworkId"),
        providerName = providerName,
        siteId = siteId,
        tags = tags,
        type = type,
    )
}
