@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetSitePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSite.
 * @property globalNetworkId ID of the Global Network of the site to retrieve.
 * @property siteId ID of the specific site to retrieve.
 * @property tags Key-value tags for the Site.
 */
public data class GetSitePlainArgs(
    public val globalNetworkId: String,
    public val siteId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetSitePlainArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetSitePlainArgs =
        com.pulumi.aws.networkmanager.inputs.GetSitePlainArgs.builder()
            .globalNetworkId(globalNetworkId.let({ args0 -> args0 }))
            .siteId(siteId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSitePlainArgs].
 */
@PulumiTagMarker
public class GetSitePlainArgsBuilder internal constructor() {
    private var globalNetworkId: String? = null

    private var siteId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the Global Network of the site to retrieve.
     */
    @JvmName("hofajqdxvoabcwgc")
    public suspend fun globalNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalNetworkId = mapped
    }

    /**
     * @param value ID of the specific site to retrieve.
     */
    @JvmName("nvbawkithcmajteq")
    public suspend fun siteId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteId = mapped
    }

    /**
     * @param value Key-value tags for the Site.
     */
    @JvmName("avwftcuekowbqryi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the Site.
     */
    @JvmName("cpufrccviqvxlmgc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSitePlainArgs = GetSitePlainArgs(
        globalNetworkId = globalNetworkId ?: throw PulumiNullFieldException("globalNetworkId"),
        siteId = siteId ?: throw PulumiNullFieldException("siteId"),
        tags = tags,
    )
}
