@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetSitesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSites.
 * @property globalNetworkId ID of the Global Network of the sites to retrieve.
 * @property tags Restricts the list to the sites with these tags.
 */
public data class GetSitesPlainArgs(
    public val globalNetworkId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetSitesPlainArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetSitesPlainArgs =
        com.pulumi.aws.networkmanager.inputs.GetSitesPlainArgs.builder()
            .globalNetworkId(globalNetworkId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSitesPlainArgs].
 */
@PulumiTagMarker
public class GetSitesPlainArgsBuilder internal constructor() {
    private var globalNetworkId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the Global Network of the sites to retrieve.
     */
    @JvmName("sffsnrxgpgfqlrhh")
    public suspend fun globalNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalNetworkId = mapped
    }

    /**
     * @param value Restricts the list to the sites with these tags.
     */
    @JvmName("nmixvmfcbjkhutcn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Restricts the list to the sites with these tags.
     */
    @JvmName("nsqimwmveccwtuiq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSitesPlainArgs = GetSitesPlainArgs(
        globalNetworkId = globalNetworkId ?: throw PulumiNullFieldException("globalNetworkId"),
        tags = tags,
    )
}
