@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.LinkBandwidthArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property downloadSpeed Download speed in Mbps.
 * @property uploadSpeed Upload speed in Mbps.
 */
public data class LinkBandwidthArgs(
    public val downloadSpeed: Output<Int>? = null,
    public val uploadSpeed: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.LinkBandwidthArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.LinkBandwidthArgs =
        com.pulumi.aws.networkmanager.inputs.LinkBandwidthArgs.builder()
            .downloadSpeed(downloadSpeed?.applyValue({ args0 -> args0 }))
            .uploadSpeed(uploadSpeed?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkBandwidthArgs].
 */
@PulumiTagMarker
public class LinkBandwidthArgsBuilder internal constructor() {
    private var downloadSpeed: Output<Int>? = null

    private var uploadSpeed: Output<Int>? = null

    /**
     * @param value Download speed in Mbps.
     */
    @JvmName("oeifaugoolfjjaqk")
    public suspend fun downloadSpeed(`value`: Output<Int>) {
        this.downloadSpeed = value
    }

    /**
     * @param value Upload speed in Mbps.
     */
    @JvmName("nxucgjsllaivmvkw")
    public suspend fun uploadSpeed(`value`: Output<Int>) {
        this.uploadSpeed = value
    }

    /**
     * @param value Download speed in Mbps.
     */
    @JvmName("vqhaqaoimkjdxnfb")
    public suspend fun downloadSpeed(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downloadSpeed = mapped
    }

    /**
     * @param value Upload speed in Mbps.
     */
    @JvmName("vhchshwdfamaxtks")
    public suspend fun uploadSpeed(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uploadSpeed = mapped
    }

    internal fun build(): LinkBandwidthArgs = LinkBandwidthArgs(
        downloadSpeed = downloadSpeed,
        uploadSpeed = uploadSpeed,
    )
}
