@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property asn ASN of a core network edge.
 * @property edgeLocation Region where a core network edge is located.
 * @property insideCidrBlocks Inside IP addresses used for core network edges.
 */
public data class CoreNetworkEdge(
    public val asn: Int? = null,
    public val edgeLocation: String? = null,
    public val insideCidrBlocks: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.CoreNetworkEdge): CoreNetworkEdge = CoreNetworkEdge(
            asn = javaType.asn().map({ args0 -> args0 }).orElse(null),
            edgeLocation = javaType.edgeLocation().map({ args0 -> args0 }).orElse(null),
            insideCidrBlocks = javaType.insideCidrBlocks().map({ args0 -> args0 }),
        )
    }
}
