@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property subnetArn The Amazon Resource Name (ARN) of the subnet that the device is located in.
 * @property zone The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
 */
public data class DeviceAwsLocation(
    public val subnetArn: String? = null,
    public val zone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.DeviceAwsLocation): DeviceAwsLocation = DeviceAwsLocation(
            subnetArn = javaType.subnetArn().map({ args0 -> args0 }).orElse(null),
            zone = javaType.zone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
