@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getConnection.
 * @property arn ARN of the connection.
 * @property connectedDeviceId ID of the second device in the connection.
 * @property connectedLinkId ID of the link for the second device.
 * @property connectionId
 * @property description Description of the connection.
 * @property deviceId ID of the first device in the connection.
 * @property globalNetworkId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property linkId ID of the link for the first device.
 * @property tags Key-value tags for the connection.
 */
public data class GetConnectionResult(
    public val arn: String,
    public val connectedDeviceId: String,
    public val connectedLinkId: String,
    public val connectionId: String,
    public val description: String,
    public val deviceId: String,
    public val globalNetworkId: String,
    public val id: String,
    public val linkId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetConnectionResult): GetConnectionResult = GetConnectionResult(
            arn = javaType.arn(),
            connectedDeviceId = javaType.connectedDeviceId(),
            connectedLinkId = javaType.connectedLinkId(),
            connectionId = javaType.connectionId(),
            description = javaType.description(),
            deviceId = javaType.deviceId(),
            globalNetworkId = javaType.globalNetworkId(),
            id = javaType.id(),
            linkId = javaType.linkId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
