@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property asn ASN of the Core Network Edge in an AWS Region. By default, the ASN will be a single integer automatically assigned from `asn_ranges`
 * @property insideCidrBlocks The local CIDR blocks for this Core Network Edge for AWS Transit Gateway Connect attachments. By default, this CIDR block will be one or more optional IPv4 and IPv6 CIDR prefixes auto-assigned from `inside_cidr_blocks`.
 * @property location
 */
public data class GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation(
    public val asn: String? = null,
    public val insideCidrBlocks: List<String>? = null,
    public val location: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation): GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation =
            GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation(
                asn = javaType.asn().map({ args0 -> args0 }).orElse(null),
                insideCidrBlocks = javaType.insideCidrBlocks().map({ args0 -> args0 }),
                location = javaType.location(),
            )
    }
}
