@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Optional description of the network function group.
 * @property name This identifies the network function group container.
 * @property requireAttachmentAcceptance This will be either `true`, that attachment acceptance is required, or `false`, that it is not required.
 */
public data class GetCoreNetworkPolicyDocumentNetworkFunctionGroup(
    public val description: String? = null,
    public val name: String,
    public val requireAttachmentAcceptance: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetCoreNetworkPolicyDocumentNetworkFunctionGroup): GetCoreNetworkPolicyDocumentNetworkFunctionGroup =
            GetCoreNetworkPolicyDocumentNetworkFunctionGroup(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                requireAttachmentAcceptance = javaType.requireAttachmentAcceptance(),
            )
    }
}
