@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property action Action to take for the chosen segment. Valid values: `create-route`, `share`, `send-via` and `send-to`.
 * @property description A user-defined string describing the segment action.
 * @property destinationCidrBlocks List of strings containing CIDRs. You can define the IPv4 and IPv6 CIDR notation for each AWS Region. For example, `10.1.0.0/16` or `2001:db8::/56`. This is an array of CIDR notation strings.
 * @property destinations A list of strings. Valid values include `["blackhole"]` or a list of attachment ids.
 * @property mode String. When `action` is `share`, a `mode` value of `attachment-route` places the attachment and return routes in each of the `share_with` segments. When `action` is `send-via`, indicates the mode used for packets. Valid values: `attachment-route`, `single-hop`, `dual-hop`.
 * @property segment Name of the segment.
 * @property shareWithExcepts A set subtraction of segments to not share with.
 * @property shareWiths A list of strings to share with. Must be a substring is all segments. Valid values include: `["*"]` or `["<segment-names>"]`.
 * @property via The network function groups and any edge overrides associated with the action.
 * @property whenSentTo The destination segments for the `send-via` or `send-to` `action`.
 */
public data class GetCoreNetworkPolicyDocumentSegmentAction(
    public val action: String,
    public val description: String? = null,
    public val destinationCidrBlocks: List<String>? = null,
    public val destinations: List<String>? = null,
    public val mode: String? = null,
    public val segment: String,
    public val shareWithExcepts: List<String>? = null,
    public val shareWiths: List<String>? = null,
    public val via: GetCoreNetworkPolicyDocumentSegmentActionVia? = null,
    public val whenSentTo: GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetCoreNetworkPolicyDocumentSegmentAction): GetCoreNetworkPolicyDocumentSegmentAction = GetCoreNetworkPolicyDocumentSegmentAction(
            action = javaType.action(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationCidrBlocks = javaType.destinationCidrBlocks().map({ args0 -> args0 }),
            destinations = javaType.destinations().map({ args0 -> args0 }),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            segment = javaType.segment(),
            shareWithExcepts = javaType.shareWithExcepts().map({ args0 -> args0 }),
            shareWiths = javaType.shareWiths().map({ args0 -> args0 }),
            via = javaType.via().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentSegmentActionVia.Companion.toKotlin(args0)
                })
            }).orElse(null),
            whenSentTo = javaType.whenSentTo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
