@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDevice.
 * @property arn ARN of the device.
 * @property awsLocations AWS location of the device. Documented below.
 * @property description Description of the device.
 * @property deviceId
 * @property globalNetworkId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property locations Location of the device. Documented below.
 * @property model Model of device.
 * @property serialNumber Serial number of the device.
 * @property siteId ID of the site.
 * @property tags Key-value tags for the device.
 * @property type Type of device.
 * @property vendor Vendor of the device.
 */
public data class GetDeviceResult(
    public val arn: String,
    public val awsLocations: List<GetDeviceAwsLocation>,
    public val description: String,
    public val deviceId: String,
    public val globalNetworkId: String,
    public val id: String,
    public val locations: List<GetDeviceLocation>,
    public val model: String,
    public val serialNumber: String,
    public val siteId: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val vendor: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetDeviceResult): GetDeviceResult = GetDeviceResult(
            arn = javaType.arn(),
            awsLocations = javaType.awsLocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkmanager.kotlin.outputs.GetDeviceAwsLocation.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            deviceId = javaType.deviceId(),
            globalNetworkId = javaType.globalNetworkId(),
            id = javaType.id(),
            locations = javaType.locations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkmanager.kotlin.outputs.GetDeviceLocation.Companion.toKotlin(args0)
                })
            }),
            model = javaType.model(),
            serialNumber = javaType.serialNumber(),
            siteId = javaType.siteId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vendor = javaType.vendor(),
        )
    }
}
