@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getGlobalNetwork.
 * @property arn ARN of the global network.
 * @property description Description of the global network.
 * @property globalNetworkId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property tags Map of resource tags.
 */
public data class GetGlobalNetworkResult(
    public val arn: String,
    public val description: String,
    public val globalNetworkId: String,
    public val id: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetGlobalNetworkResult): GetGlobalNetworkResult = GetGlobalNetworkResult(
            arn = javaType.arn(),
            description = javaType.description(),
            globalNetworkId = javaType.globalNetworkId(),
            id = javaType.id(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
