@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getGlobalNetworks.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids IDs of the global networks.
 * @property tags
 */
public data class GetGlobalNetworksResult(
    public val id: String,
    public val ids: List<String>,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetGlobalNetworksResult): GetGlobalNetworksResult = GetGlobalNetworksResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
