@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLink.
 * @property arn ARN of the link.
 * @property bandwidths Upload speed and download speed of the link as documented below
 * @property description Description of the link.
 * @property globalNetworkId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property linkId
 * @property providerName Provider of the link.
 * @property siteId ID of the site.
 * @property tags Key-value tags for the link.
 * @property type Type of the link.
 */
public data class GetLinkResult(
    public val arn: String,
    public val bandwidths: List<GetLinkBandwidth>,
    public val description: String,
    public val globalNetworkId: String,
    public val id: String,
    public val linkId: String,
    public val providerName: String,
    public val siteId: String,
    public val tags: Map<String, String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetLinkResult): GetLinkResult = GetLinkResult(
            arn = javaType.arn(),
            bandwidths = javaType.bandwidths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkmanager.kotlin.outputs.GetLinkBandwidth.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            globalNetworkId = javaType.globalNetworkId(),
            id = javaType.id(),
            linkId = javaType.linkId(),
            providerName = javaType.providerName(),
            siteId = javaType.siteId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
