@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLinks.
 * @property globalNetworkId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids IDs of the links.
 * @property providerName
 * @property siteId
 * @property tags
 * @property type
 */
public data class GetLinksResult(
    public val globalNetworkId: String,
    public val id: String,
    public val ids: List<String>,
    public val providerName: String? = null,
    public val siteId: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.GetLinksResult): GetLinksResult = GetLinksResult(
            globalNetworkId = javaType.globalNetworkId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            providerName = javaType.providerName().map({ args0 -> args0 }).orElse(null),
            siteId = javaType.siteId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
