@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address Address of the location.
 * @property latitude Latitude of the location.
 * @property longitude Longitude of the location.
 */
public data class SiteLocation(
    public val address: String? = null,
    public val latitude: String? = null,
    public val longitude: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.SiteLocation): SiteLocation = SiteLocation(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            latitude = javaType.latitude().map({ args0 -> args0 }).orElse(null),
            longitude = javaType.longitude().map({ args0 -> args0 }).orElse(null),
        )
    }
}
