@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmonitor.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Monitor].
 */
@PulumiTagMarker
public class MonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MonitorArgs = MonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MonitorArgsBuilder.() -> Unit) {
        val builder = MonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Monitor {
        val builtJavaResource = com.pulumi.aws.networkmonitor.Monitor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Monitor(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Network Monitor Monitor.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmonitor.Monitor("example", {
 *     aggregationPeriod: 30,
 *     monitorName: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmonitor.Monitor("example",
 *     aggregation_period=30,
 *     monitor_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkMonitor.Monitor("example", new()
 *     {
 *         AggregationPeriod = 30,
 *         MonitorName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmonitor"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmonitor.NewMonitor(ctx, "example", &networkmonitor.MonitorArgs{
 * 			AggregationPeriod: pulumi.Int(30),
 * 			MonitorName:       pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmonitor.Monitor;
 * import com.pulumi.aws.networkmonitor.MonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Monitor("example", MonitorArgs.builder()
 *             .aggregationPeriod(30)
 *             .monitorName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmonitor:Monitor
 *     properties:
 *       aggregationPeriod: 30
 *       monitorName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmonitor_monitor` using the monitor name. For example:
 * ```sh
 * $ pulumi import aws:networkmonitor/monitor:Monitor example monitor-7786087912324693644
 * ```
 */
public class Monitor internal constructor(
    override val javaResource: com.pulumi.aws.networkmonitor.Monitor,
) : KotlinCustomResource(javaResource, MonitorMapper) {
    /**
     * The time, in seconds, that metrics are aggregated and sent to Amazon CloudWatch. Valid values are either 30 or 60.
     */
    public val aggregationPeriod: Output<Int>?
        get() = javaResource.aggregationPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the monitor.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the monitor.
     * The following arguments are optional:
     */
    public val monitorName: Output<String>
        get() = javaResource.monitorName().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object MonitorMapper : ResourceMapper<Monitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmonitor.Monitor::class == javaResource::class

    override fun map(javaResource: Resource): Monitor = Monitor(
        javaResource as
            com.pulumi.aws.networkmonitor.Monitor,
    )
}

/**
 * @see [Monitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Monitor].
 */
public suspend fun monitor(name: String, block: suspend MonitorResourceBuilder.() -> Unit): Monitor {
    val builder = MonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Monitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun monitor(name: String): Monitor {
    val builder = MonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
