@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmonitor.kotlin

import com.pulumi.aws.networkmonitor.MonitorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Monitor Monitor.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmonitor.Monitor("example", {
 *     aggregationPeriod: 30,
 *     monitorName: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmonitor.Monitor("example",
 *     aggregation_period=30,
 *     monitor_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkMonitor.Monitor("example", new()
 *     {
 *         AggregationPeriod = 30,
 *         MonitorName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmonitor"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmonitor.NewMonitor(ctx, "example", &networkmonitor.MonitorArgs{
 * 			AggregationPeriod: pulumi.Int(30),
 * 			MonitorName:       pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmonitor.Monitor;
 * import com.pulumi.aws.networkmonitor.MonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Monitor("example", MonitorArgs.builder()
 *             .aggregationPeriod(30)
 *             .monitorName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmonitor:Monitor
 *     properties:
 *       aggregationPeriod: 30
 *       monitorName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmonitor_monitor` using the monitor name. For example:
 * ```sh
 * $ pulumi import aws:networkmonitor/monitor:Monitor example monitor-7786087912324693644
 * ```
 * @property aggregationPeriod The time, in seconds, that metrics are aggregated and sent to Amazon CloudWatch. Valid values are either 30 or 60.
 * @property monitorName The name of the monitor.
 * The following arguments are optional:
 * @property tags Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class MonitorArgs(
    public val aggregationPeriod: Output<Int>? = null,
    public val monitorName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmonitor.MonitorArgs> {
    override fun toJava(): com.pulumi.aws.networkmonitor.MonitorArgs =
        com.pulumi.aws.networkmonitor.MonitorArgs.builder()
            .aggregationPeriod(aggregationPeriod?.applyValue({ args0 -> args0 }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MonitorArgs].
 */
@PulumiTagMarker
public class MonitorArgsBuilder internal constructor() {
    private var aggregationPeriod: Output<Int>? = null

    private var monitorName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The time, in seconds, that metrics are aggregated and sent to Amazon CloudWatch. Valid values are either 30 or 60.
     */
    @JvmName("mlejaielvaxnjuuk")
    public suspend fun aggregationPeriod(`value`: Output<Int>) {
        this.aggregationPeriod = value
    }

    /**
     * @param value The name of the monitor.
     * The following arguments are optional:
     */
    @JvmName("bcrxxfhuempryyqv")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dujqtebaawolmrtd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The time, in seconds, that metrics are aggregated and sent to Amazon CloudWatch. Valid values are either 30 or 60.
     */
    @JvmName("dtcqqkqarexuginn")
    public suspend fun aggregationPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregationPeriod = mapped
    }

    /**
     * @param value The name of the monitor.
     * The following arguments are optional:
     */
    @JvmName("rmaqtyuelovmqive")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("meldufwrrkjvxout")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cidpvsvlmvsffhyn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MonitorArgs = MonitorArgs(
        aggregationPeriod = aggregationPeriod,
        monitorName = monitorName,
        tags = tags,
    )
}
