@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmonitor.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Probe].
 */
@PulumiTagMarker
public class ProbeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProbeArgs = ProbeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProbeArgsBuilder.() -> Unit) {
        val builder = ProbeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Probe {
        val builtJavaResource = com.pulumi.aws.networkmonitor.Probe(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Probe(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Network Monitor Probe.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmonitor.Monitor("example", {
 *     aggregationPeriod: 30,
 *     monitorName: "example",
 * });
 * const exampleProbe = new aws.networkmonitor.Probe("example", {
 *     monitorName: example.monitorName,
 *     destination: "127.0.0.1",
 *     destinationPort: 80,
 *     protocol: "TCP",
 *     sourceArn: exampleAwsSubnet.arn,
 *     packetSize: 200,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmonitor.Monitor("example",
 *     aggregation_period=30,
 *     monitor_name="example")
 * example_probe = aws.networkmonitor.Probe("example",
 *     monitor_name=example.monitor_name,
 *     destination="127.0.0.1",
 *     destination_port=80,
 *     protocol="TCP",
 *     source_arn=example_aws_subnet["arn"],
 *     packet_size=200)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkMonitor.Monitor("example", new()
 *     {
 *         AggregationPeriod = 30,
 *         MonitorName = "example",
 *     });
 *     var exampleProbe = new Aws.NetworkMonitor.Probe("example", new()
 *     {
 *         MonitorName = example.MonitorName,
 *         Destination = "127.0.0.1",
 *         DestinationPort = 80,
 *         Protocol = "TCP",
 *         SourceArn = exampleAwsSubnet.Arn,
 *         PacketSize = 200,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmonitor"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := networkmonitor.NewMonitor(ctx, "example", &networkmonitor.MonitorArgs{
 * 			AggregationPeriod: pulumi.Int(30),
 * 			MonitorName:       pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = networkmonitor.NewProbe(ctx, "example", &networkmonitor.ProbeArgs{
 * 			MonitorName:     example.MonitorName,
 * 			Destination:     pulumi.String("127.0.0.1"),
 * 			DestinationPort: pulumi.Int(80),
 * 			Protocol:        pulumi.String("TCP"),
 * 			SourceArn:       pulumi.Any(exampleAwsSubnet.Arn),
 * 			PacketSize:      pulumi.Int(200),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmonitor.Monitor;
 * import com.pulumi.aws.networkmonitor.MonitorArgs;
 * import com.pulumi.aws.networkmonitor.Probe;
 * import com.pulumi.aws.networkmonitor.ProbeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Monitor("example", MonitorArgs.builder()
 *             .aggregationPeriod(30)
 *             .monitorName("example")
 *             .build());
 *         var exampleProbe = new Probe("exampleProbe", ProbeArgs.builder()
 *             .monitorName(example.monitorName())
 *             .destination("127.0.0.1")
 *             .destinationPort(80)
 *             .protocol("TCP")
 *             .sourceArn(exampleAwsSubnet.arn())
 *             .packetSize(200)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmonitor:Monitor
 *     properties:
 *       aggregationPeriod: 30
 *       monitorName: example
 *   exampleProbe:
 *     type: aws:networkmonitor:Probe
 *     name: example
 *     properties:
 *       monitorName: ${example.monitorName}
 *       destination: 127.0.0.1
 *       destinationPort: 80
 *       protocol: TCP
 *       sourceArn: ${exampleAwsSubnet.arn}
 *       packetSize: 200
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmonitor_probe` using the monitor name and probe id. For example:
 * ```sh
 * $ pulumi import aws:networkmonitor/probe:Probe example monitor-7786087912324693644,probe-3qm8p693i4fi1h8lqylzkbp42e
 * ```
 */
public class Probe internal constructor(
    override val javaResource: com.pulumi.aws.networkmonitor.Probe,
) : KotlinCustomResource(javaResource, ProbeMapper) {
    public val addressFamily: Output<String>
        get() = javaResource.addressFamily().applyValue({ args0 -> args0 })

    /**
     * The ARN of the attachment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The destination IP address. This must be either IPV4 or IPV6.
     */
    public val destination: Output<String>
        get() = javaResource.destination().applyValue({ args0 -> args0 })

    /**
     * The port associated with the destination. This is required only if the protocol is TCP and must be a number between 1 and 65536.
     */
    public val destinationPort: Output<Int>?
        get() = javaResource.destinationPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the monitor.
     */
    public val monitorName: Output<String>
        get() = javaResource.monitorName().applyValue({ args0 -> args0 })

    /**
     * The size of the packets sent between the source and destination. This must be a number between 56 and 8500.
     * The following arguments are optional:
     */
    public val packetSize: Output<Int>
        get() = javaResource.packetSize().applyValue({ args0 -> args0 })

    public val probeId: Output<String>
        get() = javaResource.probeId().applyValue({ args0 -> args0 })

    /**
     * The protocol used for the network traffic between the source and destination. This must be either TCP or ICMP.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * The ARN of the subnet.
     */
    public val sourceArn: Output<String>
        get() = javaResource.sourceArn().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object ProbeMapper : ResourceMapper<Probe> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmonitor.Probe::class == javaResource::class

    override fun map(javaResource: Resource): Probe = Probe(
        javaResource as
            com.pulumi.aws.networkmonitor.Probe,
    )
}

/**
 * @see [Probe].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Probe].
 */
public suspend fun probe(name: String, block: suspend ProbeResourceBuilder.() -> Unit): Probe {
    val builder = ProbeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Probe].
 * @param name The _unique_ name of the resulting resource.
 */
public fun probe(name: String): Probe {
    val builder = ProbeResourceBuilder()
    builder.name(name)
    return builder.build()
}
