@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmonitor.kotlin

import com.pulumi.aws.networkmonitor.ProbeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Monitor Probe.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmonitor.Monitor("example", {
 *     aggregationPeriod: 30,
 *     monitorName: "example",
 * });
 * const exampleProbe = new aws.networkmonitor.Probe("example", {
 *     monitorName: example.monitorName,
 *     destination: "127.0.0.1",
 *     destinationPort: 80,
 *     protocol: "TCP",
 *     sourceArn: exampleAwsSubnet.arn,
 *     packetSize: 200,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmonitor.Monitor("example",
 *     aggregation_period=30,
 *     monitor_name="example")
 * example_probe = aws.networkmonitor.Probe("example",
 *     monitor_name=example.monitor_name,
 *     destination="127.0.0.1",
 *     destination_port=80,
 *     protocol="TCP",
 *     source_arn=example_aws_subnet["arn"],
 *     packet_size=200)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkMonitor.Monitor("example", new()
 *     {
 *         AggregationPeriod = 30,
 *         MonitorName = "example",
 *     });
 *     var exampleProbe = new Aws.NetworkMonitor.Probe("example", new()
 *     {
 *         MonitorName = example.MonitorName,
 *         Destination = "127.0.0.1",
 *         DestinationPort = 80,
 *         Protocol = "TCP",
 *         SourceArn = exampleAwsSubnet.Arn,
 *         PacketSize = 200,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmonitor"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := networkmonitor.NewMonitor(ctx, "example", &networkmonitor.MonitorArgs{
 * 			AggregationPeriod: pulumi.Int(30),
 * 			MonitorName:       pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = networkmonitor.NewProbe(ctx, "example", &networkmonitor.ProbeArgs{
 * 			MonitorName:     example.MonitorName,
 * 			Destination:     pulumi.String("127.0.0.1"),
 * 			DestinationPort: pulumi.Int(80),
 * 			Protocol:        pulumi.String("TCP"),
 * 			SourceArn:       pulumi.Any(exampleAwsSubnet.Arn),
 * 			PacketSize:      pulumi.Int(200),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmonitor.Monitor;
 * import com.pulumi.aws.networkmonitor.MonitorArgs;
 * import com.pulumi.aws.networkmonitor.Probe;
 * import com.pulumi.aws.networkmonitor.ProbeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Monitor("example", MonitorArgs.builder()
 *             .aggregationPeriod(30)
 *             .monitorName("example")
 *             .build());
 *         var exampleProbe = new Probe("exampleProbe", ProbeArgs.builder()
 *             .monitorName(example.monitorName())
 *             .destination("127.0.0.1")
 *             .destinationPort(80)
 *             .protocol("TCP")
 *             .sourceArn(exampleAwsSubnet.arn())
 *             .packetSize(200)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmonitor:Monitor
 *     properties:
 *       aggregationPeriod: 30
 *       monitorName: example
 *   exampleProbe:
 *     type: aws:networkmonitor:Probe
 *     name: example
 *     properties:
 *       monitorName: ${example.monitorName}
 *       destination: 127.0.0.1
 *       destinationPort: 80
 *       protocol: TCP
 *       sourceArn: ${exampleAwsSubnet.arn}
 *       packetSize: 200
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmonitor_probe` using the monitor name and probe id. For example:
 * ```sh
 * $ pulumi import aws:networkmonitor/probe:Probe example monitor-7786087912324693644,probe-3qm8p693i4fi1h8lqylzkbp42e
 * ```
 * @property destination The destination IP address. This must be either IPV4 or IPV6.
 * @property destinationPort The port associated with the destination. This is required only if the protocol is TCP and must be a number between 1 and 65536.
 * @property monitorName The name of the monitor.
 * @property packetSize The size of the packets sent between the source and destination. This must be a number between 56 and 8500.
 * The following arguments are optional:
 * @property protocol The protocol used for the network traffic between the source and destination. This must be either TCP or ICMP.
 * @property sourceArn The ARN of the subnet.
 * @property tags Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ProbeArgs(
    public val destination: Output<String>? = null,
    public val destinationPort: Output<Int>? = null,
    public val monitorName: Output<String>? = null,
    public val packetSize: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val sourceArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmonitor.ProbeArgs> {
    override fun toJava(): com.pulumi.aws.networkmonitor.ProbeArgs =
        com.pulumi.aws.networkmonitor.ProbeArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0 }))
            .destinationPort(destinationPort?.applyValue({ args0 -> args0 }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .packetSize(packetSize?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .sourceArn(sourceArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProbeArgs].
 */
@PulumiTagMarker
public class ProbeArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var destinationPort: Output<Int>? = null

    private var monitorName: Output<String>? = null

    private var packetSize: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var sourceArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The destination IP address. This must be either IPV4 or IPV6.
     */
    @JvmName("tluxqeqdsevkeqka")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value The port associated with the destination. This is required only if the protocol is TCP and must be a number between 1 and 65536.
     */
    @JvmName("nedpdefmnjnsivuo")
    public suspend fun destinationPort(`value`: Output<Int>) {
        this.destinationPort = value
    }

    /**
     * @param value The name of the monitor.
     */
    @JvmName("otxxaxqqsewhuipj")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value The size of the packets sent between the source and destination. This must be a number between 56 and 8500.
     * The following arguments are optional:
     */
    @JvmName("oevdxpjmmxnxcetg")
    public suspend fun packetSize(`value`: Output<Int>) {
        this.packetSize = value
    }

    /**
     * @param value The protocol used for the network traffic between the source and destination. This must be either TCP or ICMP.
     */
    @JvmName("cwsnepopbqbctihy")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The ARN of the subnet.
     */
    @JvmName("qchinolpuptougrv")
    public suspend fun sourceArn(`value`: Output<String>) {
        this.sourceArn = value
    }

    /**
     * @param value Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fsbtkkghgdlwxfxb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The destination IP address. This must be either IPV4 or IPV6.
     */
    @JvmName("aayafgajhxfgilag")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value The port associated with the destination. This is required only if the protocol is TCP and must be a number between 1 and 65536.
     */
    @JvmName("rxxvybcbbpcvvekp")
    public suspend fun destinationPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPort = mapped
    }

    /**
     * @param value The name of the monitor.
     */
    @JvmName("jqabwdpncslwgmgy")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value The size of the packets sent between the source and destination. This must be a number between 56 and 8500.
     * The following arguments are optional:
     */
    @JvmName("anljymvvvihsyyoi")
    public suspend fun packetSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetSize = mapped
    }

    /**
     * @param value The protocol used for the network traffic between the source and destination. This must be either TCP or ICMP.
     */
    @JvmName("hydqgolroemiychy")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The ARN of the subnet.
     */
    @JvmName("xnobuwtlcuheluih")
    public suspend fun sourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceArn = mapped
    }

    /**
     * @param value Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ltwwmrueyhremvhu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sbevuhoqlwbrtnqd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProbeArgs = ProbeArgs(
        destination = destination,
        destinationPort = destinationPort,
        monitorName = monitorName,
        packetSize = packetSize,
        protocol = protocol,
        sourceArn = sourceArn,
        tags = tags,
    )
}
