@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin

import com.pulumi.aws.oam.kotlin.outputs.LinkLinkConfiguration
import com.pulumi.aws.oam.kotlin.outputs.LinkLinkConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Link].
 */
@PulumiTagMarker
public class LinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkArgs = LinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkArgsBuilder.() -> Unit) {
        val builder = LinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Link {
        val builtJavaResource = com.pulumi.aws.oam.Link(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Link(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS CloudWatch Observability Access Manager Link.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.oam.Link("example", {
 *     labelTemplate: "$AccountName",
 *     resourceTypes: ["AWS::CloudWatch::Metric"],
 *     sinkIdentifier: test.id,
 *     tags: {
 *         Env: "prod",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.oam.Link("example",
 *     label_template="$AccountName",
 *     resource_types=["AWS::CloudWatch::Metric"],
 *     sink_identifier=test["id"],
 *     tags={
 *         "Env": "prod",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Oam.Link("example", new()
 *     {
 *         LabelTemplate = "$AccountName",
 *         ResourceTypes = new[]
 *         {
 *             "AWS::CloudWatch::Metric",
 *         },
 *         SinkIdentifier = test.Id,
 *         Tags =
 *         {
 *             { "Env", "prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := oam.NewLink(ctx, "example", &oam.LinkArgs{
 * 			LabelTemplate: pulumi.String("$AccountName"),
 * 			ResourceTypes: pulumi.StringArray{
 * 				pulumi.String("AWS::CloudWatch::Metric"),
 * 			},
 * 			SinkIdentifier: pulumi.Any(test.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Env": pulumi.String("prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Link;
 * import com.pulumi.aws.oam.LinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Link("example", LinkArgs.builder()
 *             .labelTemplate("$AccountName")
 *             .resourceTypes("AWS::CloudWatch::Metric")
 *             .sinkIdentifier(test.id())
 *             .tags(Map.of("Env", "prod"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:oam:Link
 *     properties:
 *       labelTemplate: $AccountName
 *       resourceTypes:
 *         - AWS::CloudWatch::Metric
 *       sinkIdentifier: ${test.id}
 *       tags:
 *         Env: prod
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Log Group Filtering
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.oam.Link("example", {
 *     labelTemplate: "$AccountName",
 *     linkConfiguration: {
 *         logGroupConfiguration: {
 *             filter: "LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'",
 *         },
 *     },
 *     resourceTypes: ["AWS::Logs::LogGroup"],
 *     sinkIdentifier: test.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.oam.Link("example",
 *     label_template="$AccountName",
 *     link_configuration={
 *         "log_group_configuration": {
 *             "filter": "LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'",
 *         },
 *     },
 *     resource_types=["AWS::Logs::LogGroup"],
 *     sink_identifier=test["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Oam.Link("example", new()
 *     {
 *         LabelTemplate = "$AccountName",
 *         LinkConfiguration = new Aws.Oam.Inputs.LinkLinkConfigurationArgs
 *         {
 *             LogGroupConfiguration = new Aws.Oam.Inputs.LinkLinkConfigurationLogGroupConfigurationArgs
 *             {
 *                 Filter = "LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'",
 *             },
 *         },
 *         ResourceTypes = new[]
 *         {
 *             "AWS::Logs::LogGroup",
 *         },
 *         SinkIdentifier = test.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := oam.NewLink(ctx, "example", &oam.LinkArgs{
 * 			LabelTemplate: pulumi.String("$AccountName"),
 * 			LinkConfiguration: &oam.LinkLinkConfigurationArgs{
 * 				LogGroupConfiguration: &oam.LinkLinkConfigurationLogGroupConfigurationArgs{
 * 					Filter: pulumi.String("LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'"),
 * 				},
 * 			},
 * 			ResourceTypes: pulumi.StringArray{
 * 				pulumi.String("AWS::Logs::LogGroup"),
 * 			},
 * 			SinkIdentifier: pulumi.Any(test.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Link;
 * import com.pulumi.aws.oam.LinkArgs;
 * import com.pulumi.aws.oam.inputs.LinkLinkConfigurationArgs;
 * import com.pulumi.aws.oam.inputs.LinkLinkConfigurationLogGroupConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Link("example", LinkArgs.builder()
 *             .labelTemplate("$AccountName")
 *             .linkConfiguration(LinkLinkConfigurationArgs.builder()
 *                 .logGroupConfiguration(LinkLinkConfigurationLogGroupConfigurationArgs.builder()
 *                     .filter("LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'")
 *                     .build())
 *                 .build())
 *             .resourceTypes("AWS::Logs::LogGroup")
 *             .sinkIdentifier(test.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:oam:Link
 *     properties:
 *       labelTemplate: $AccountName
 *       linkConfiguration:
 *         logGroupConfiguration:
 *           filter: LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'
 *       resourceTypes:
 *         - AWS::Logs::LogGroup
 *       sinkIdentifier: ${test.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Metric Filtering
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.oam.Link("example", {
 *     labelTemplate: "$AccountName",
 *     linkConfiguration: {
 *         metricConfiguration: {
 *             filter: "Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')",
 *         },
 *     },
 *     resourceTypes: ["AWS::CloudWatch::Metric"],
 *     sinkIdentifier: test.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.oam.Link("example",
 *     label_template="$AccountName",
 *     link_configuration={
 *         "metric_configuration": {
 *             "filter": "Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')",
 *         },
 *     },
 *     resource_types=["AWS::CloudWatch::Metric"],
 *     sink_identifier=test["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Oam.Link("example", new()
 *     {
 *         LabelTemplate = "$AccountName",
 *         LinkConfiguration = new Aws.Oam.Inputs.LinkLinkConfigurationArgs
 *         {
 *             MetricConfiguration = new Aws.Oam.Inputs.LinkLinkConfigurationMetricConfigurationArgs
 *             {
 *                 Filter = "Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')",
 *             },
 *         },
 *         ResourceTypes = new[]
 *         {
 *             "AWS::CloudWatch::Metric",
 *         },
 *         SinkIdentifier = test.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := oam.NewLink(ctx, "example", &oam.LinkArgs{
 * 			LabelTemplate: pulumi.String("$AccountName"),
 * 			LinkConfiguration: &oam.LinkLinkConfigurationArgs{
 * 				MetricConfiguration: &oam.LinkLinkConfigurationMetricConfigurationArgs{
 * 					Filter: pulumi.String("Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')"),
 * 				},
 * 			},
 * 			ResourceTypes: pulumi.StringArray{
 * 				pulumi.String("AWS::CloudWatch::Metric"),
 * 			},
 * 			SinkIdentifier: pulumi.Any(test.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Link;
 * import com.pulumi.aws.oam.LinkArgs;
 * import com.pulumi.aws.oam.inputs.LinkLinkConfigurationArgs;
 * import com.pulumi.aws.oam.inputs.LinkLinkConfigurationMetricConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Link("example", LinkArgs.builder()
 *             .labelTemplate("$AccountName")
 *             .linkConfiguration(LinkLinkConfigurationArgs.builder()
 *                 .metricConfiguration(LinkLinkConfigurationMetricConfigurationArgs.builder()
 *                     .filter("Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')")
 *                     .build())
 *                 .build())
 *             .resourceTypes("AWS::CloudWatch::Metric")
 *             .sinkIdentifier(test.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:oam:Link
 *     properties:
 *       labelTemplate: $AccountName
 *       linkConfiguration:
 *         metricConfiguration:
 *           filter: Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')
 *       resourceTypes:
 *         - AWS::CloudWatch::Metric
 *       sinkIdentifier: ${test.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Observability Access Manager Link using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:oam/link:Link example arn:aws:oam:us-west-2:123456789012:link/link-id
 * ```
 */
public class Link internal constructor(
    override val javaResource: com.pulumi.aws.oam.Link,
) : KotlinCustomResource(javaResource, LinkMapper) {
    /**
     * ARN of the link.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Label that is assigned to this link.
     */
    public val label: Output<String>
        get() = javaResource.label().applyValue({ args0 -> args0 })

    /**
     * Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
     */
    public val labelTemplate: Output<String>
        get() = javaResource.labelTemplate().applyValue({ args0 -> args0 })

    /**
     * Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
     */
    public val linkConfiguration: Output<LinkLinkConfiguration>?
        get() = javaResource.linkConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * ID string that AWS generated as part of the link ARN.
     */
    public val linkId: Output<String>
        get() = javaResource.linkId().applyValue({ args0 -> args0 })

    /**
     * Types of data that the source account shares with the monitoring account.
     */
    public val resourceTypes: Output<List<String>>
        get() = javaResource.resourceTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * ARN of the sink that is used for this link.
     */
    public val sinkArn: Output<String>
        get() = javaResource.sinkArn().applyValue({ args0 -> args0 })

    /**
     * Identifier of the sink to use to create this link.
     * The following arguments are optional:
     */
    public val sinkIdentifier: Output<String>
        get() = javaResource.sinkIdentifier().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object LinkMapper : ResourceMapper<Link> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.oam.Link::class == javaResource::class

    override fun map(javaResource: Resource): Link = Link(javaResource as com.pulumi.aws.oam.Link)
}

/**
 * @see [Link].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Link].
 */
public suspend fun link(name: String, block: suspend LinkResourceBuilder.() -> Unit): Link {
    val builder = LinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Link].
 * @param name The _unique_ name of the resulting resource.
 */
public fun link(name: String): Link {
    val builder = LinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
