@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin

import com.pulumi.aws.oam.LinkArgs.builder
import com.pulumi.aws.oam.kotlin.inputs.LinkLinkConfigurationArgs
import com.pulumi.aws.oam.kotlin.inputs.LinkLinkConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CloudWatch Observability Access Manager Link.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.oam.Link("example", {
 *     labelTemplate: "$AccountName",
 *     resourceTypes: ["AWS::CloudWatch::Metric"],
 *     sinkIdentifier: test.id,
 *     tags: {
 *         Env: "prod",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.oam.Link("example",
 *     label_template="$AccountName",
 *     resource_types=["AWS::CloudWatch::Metric"],
 *     sink_identifier=test["id"],
 *     tags={
 *         "Env": "prod",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Oam.Link("example", new()
 *     {
 *         LabelTemplate = "$AccountName",
 *         ResourceTypes = new[]
 *         {
 *             "AWS::CloudWatch::Metric",
 *         },
 *         SinkIdentifier = test.Id,
 *         Tags =
 *         {
 *             { "Env", "prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := oam.NewLink(ctx, "example", &oam.LinkArgs{
 * 			LabelTemplate: pulumi.String("$AccountName"),
 * 			ResourceTypes: pulumi.StringArray{
 * 				pulumi.String("AWS::CloudWatch::Metric"),
 * 			},
 * 			SinkIdentifier: pulumi.Any(test.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Env": pulumi.String("prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Link;
 * import com.pulumi.aws.oam.LinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Link("example", LinkArgs.builder()
 *             .labelTemplate("$AccountName")
 *             .resourceTypes("AWS::CloudWatch::Metric")
 *             .sinkIdentifier(test.id())
 *             .tags(Map.of("Env", "prod"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:oam:Link
 *     properties:
 *       labelTemplate: $AccountName
 *       resourceTypes:
 *         - AWS::CloudWatch::Metric
 *       sinkIdentifier: ${test.id}
 *       tags:
 *         Env: prod
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Log Group Filtering
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.oam.Link("example", {
 *     labelTemplate: "$AccountName",
 *     linkConfiguration: {
 *         logGroupConfiguration: {
 *             filter: "LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'",
 *         },
 *     },
 *     resourceTypes: ["AWS::Logs::LogGroup"],
 *     sinkIdentifier: test.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.oam.Link("example",
 *     label_template="$AccountName",
 *     link_configuration={
 *         "log_group_configuration": {
 *             "filter": "LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'",
 *         },
 *     },
 *     resource_types=["AWS::Logs::LogGroup"],
 *     sink_identifier=test["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Oam.Link("example", new()
 *     {
 *         LabelTemplate = "$AccountName",
 *         LinkConfiguration = new Aws.Oam.Inputs.LinkLinkConfigurationArgs
 *         {
 *             LogGroupConfiguration = new Aws.Oam.Inputs.LinkLinkConfigurationLogGroupConfigurationArgs
 *             {
 *                 Filter = "LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'",
 *             },
 *         },
 *         ResourceTypes = new[]
 *         {
 *             "AWS::Logs::LogGroup",
 *         },
 *         SinkIdentifier = test.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := oam.NewLink(ctx, "example", &oam.LinkArgs{
 * 			LabelTemplate: pulumi.String("$AccountName"),
 * 			LinkConfiguration: &oam.LinkLinkConfigurationArgs{
 * 				LogGroupConfiguration: &oam.LinkLinkConfigurationLogGroupConfigurationArgs{
 * 					Filter: pulumi.String("LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'"),
 * 				},
 * 			},
 * 			ResourceTypes: pulumi.StringArray{
 * 				pulumi.String("AWS::Logs::LogGroup"),
 * 			},
 * 			SinkIdentifier: pulumi.Any(test.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Link;
 * import com.pulumi.aws.oam.LinkArgs;
 * import com.pulumi.aws.oam.inputs.LinkLinkConfigurationArgs;
 * import com.pulumi.aws.oam.inputs.LinkLinkConfigurationLogGroupConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Link("example", LinkArgs.builder()
 *             .labelTemplate("$AccountName")
 *             .linkConfiguration(LinkLinkConfigurationArgs.builder()
 *                 .logGroupConfiguration(LinkLinkConfigurationLogGroupConfigurationArgs.builder()
 *                     .filter("LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'")
 *                     .build())
 *                 .build())
 *             .resourceTypes("AWS::Logs::LogGroup")
 *             .sinkIdentifier(test.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:oam:Link
 *     properties:
 *       labelTemplate: $AccountName
 *       linkConfiguration:
 *         logGroupConfiguration:
 *           filter: LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'
 *       resourceTypes:
 *         - AWS::Logs::LogGroup
 *       sinkIdentifier: ${test.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Metric Filtering
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.oam.Link("example", {
 *     labelTemplate: "$AccountName",
 *     linkConfiguration: {
 *         metricConfiguration: {
 *             filter: "Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')",
 *         },
 *     },
 *     resourceTypes: ["AWS::CloudWatch::Metric"],
 *     sinkIdentifier: test.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.oam.Link("example",
 *     label_template="$AccountName",
 *     link_configuration={
 *         "metric_configuration": {
 *             "filter": "Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')",
 *         },
 *     },
 *     resource_types=["AWS::CloudWatch::Metric"],
 *     sink_identifier=test["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Oam.Link("example", new()
 *     {
 *         LabelTemplate = "$AccountName",
 *         LinkConfiguration = new Aws.Oam.Inputs.LinkLinkConfigurationArgs
 *         {
 *             MetricConfiguration = new Aws.Oam.Inputs.LinkLinkConfigurationMetricConfigurationArgs
 *             {
 *                 Filter = "Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')",
 *             },
 *         },
 *         ResourceTypes = new[]
 *         {
 *             "AWS::CloudWatch::Metric",
 *         },
 *         SinkIdentifier = test.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := oam.NewLink(ctx, "example", &oam.LinkArgs{
 * 			LabelTemplate: pulumi.String("$AccountName"),
 * 			LinkConfiguration: &oam.LinkLinkConfigurationArgs{
 * 				MetricConfiguration: &oam.LinkLinkConfigurationMetricConfigurationArgs{
 * 					Filter: pulumi.String("Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')"),
 * 				},
 * 			},
 * 			ResourceTypes: pulumi.StringArray{
 * 				pulumi.String("AWS::CloudWatch::Metric"),
 * 			},
 * 			SinkIdentifier: pulumi.Any(test.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Link;
 * import com.pulumi.aws.oam.LinkArgs;
 * import com.pulumi.aws.oam.inputs.LinkLinkConfigurationArgs;
 * import com.pulumi.aws.oam.inputs.LinkLinkConfigurationMetricConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Link("example", LinkArgs.builder()
 *             .labelTemplate("$AccountName")
 *             .linkConfiguration(LinkLinkConfigurationArgs.builder()
 *                 .metricConfiguration(LinkLinkConfigurationMetricConfigurationArgs.builder()
 *                     .filter("Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')")
 *                     .build())
 *                 .build())
 *             .resourceTypes("AWS::CloudWatch::Metric")
 *             .sinkIdentifier(test.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:oam:Link
 *     properties:
 *       labelTemplate: $AccountName
 *       linkConfiguration:
 *         metricConfiguration:
 *           filter: Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')
 *       resourceTypes:
 *         - AWS::CloudWatch::Metric
 *       sinkIdentifier: ${test.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Observability Access Manager Link using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:oam/link:Link example arn:aws:oam:us-west-2:123456789012:link/link-id
 * ```
 * @property labelTemplate Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
 * @property linkConfiguration Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
 * @property resourceTypes Types of data that the source account shares with the monitoring account.
 * @property sinkIdentifier Identifier of the sink to use to create this link.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LinkArgs(
    public val labelTemplate: Output<String>? = null,
    public val linkConfiguration: Output<LinkLinkConfigurationArgs>? = null,
    public val resourceTypes: Output<List<String>>? = null,
    public val sinkIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.oam.LinkArgs> {
    override fun toJava(): com.pulumi.aws.oam.LinkArgs = com.pulumi.aws.oam.LinkArgs.builder()
        .labelTemplate(labelTemplate?.applyValue({ args0 -> args0 }))
        .linkConfiguration(linkConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .resourceTypes(resourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .sinkIdentifier(sinkIdentifier?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [LinkArgs].
 */
@PulumiTagMarker
public class LinkArgsBuilder internal constructor() {
    private var labelTemplate: Output<String>? = null

    private var linkConfiguration: Output<LinkLinkConfigurationArgs>? = null

    private var resourceTypes: Output<List<String>>? = null

    private var sinkIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
     */
    @JvmName("xylkapfohyyeknoy")
    public suspend fun labelTemplate(`value`: Output<String>) {
        this.labelTemplate = value
    }

    /**
     * @param value Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
     */
    @JvmName("hwyrjllbrbyvvqxp")
    public suspend fun linkConfiguration(`value`: Output<LinkLinkConfigurationArgs>) {
        this.linkConfiguration = value
    }

    /**
     * @param value Types of data that the source account shares with the monitoring account.
     */
    @JvmName("llwbbkgiwowmadnh")
    public suspend fun resourceTypes(`value`: Output<List<String>>) {
        this.resourceTypes = value
    }

    @JvmName("mjdgfoudereivhwh")
    public suspend fun resourceTypes(vararg values: Output<String>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values Types of data that the source account shares with the monitoring account.
     */
    @JvmName("bkevwmtlyycvprum")
    public suspend fun resourceTypes(values: List<Output<String>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value Identifier of the sink to use to create this link.
     * The following arguments are optional:
     */
    @JvmName("ymomtdlsxemgdjpy")
    public suspend fun sinkIdentifier(`value`: Output<String>) {
        this.sinkIdentifier = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mwsbwvuljcgdibda")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
     */
    @JvmName("ivwgmvhqmnnhlpbn")
    public suspend fun labelTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelTemplate = mapped
    }

    /**
     * @param value Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
     */
    @JvmName("uctedxfmrxxrrkxb")
    public suspend fun linkConfiguration(`value`: LinkLinkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkConfiguration = mapped
    }

    /**
     * @param argument Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
     */
    @JvmName("drhqsqwyeevuecwo")
    public suspend fun linkConfiguration(argument: suspend LinkLinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LinkLinkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkConfiguration = mapped
    }

    /**
     * @param value Types of data that the source account shares with the monitoring account.
     */
    @JvmName("kqnnijryqmsmqnjw")
    public suspend fun resourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param values Types of data that the source account shares with the monitoring account.
     */
    @JvmName("vwwjuyefeskxbkyl")
    public suspend fun resourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param value Identifier of the sink to use to create this link.
     * The following arguments are optional:
     */
    @JvmName("qnpbgyhyegxwenad")
    public suspend fun sinkIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkIdentifier = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hlsvnrfltllsevan")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fvolecxqmmlqepwl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LinkArgs = LinkArgs(
        labelTemplate = labelTemplate,
        linkConfiguration = linkConfiguration,
        resourceTypes = resourceTypes,
        sinkIdentifier = sinkIdentifier,
        tags = tags,
    )
}
