@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin

import com.pulumi.aws.oam.OamFunctions.getLinkPlain
import com.pulumi.aws.oam.OamFunctions.getLinksPlain
import com.pulumi.aws.oam.OamFunctions.getSinkPlain
import com.pulumi.aws.oam.OamFunctions.getSinksPlain
import com.pulumi.aws.oam.kotlin.inputs.GetLinkPlainArgs
import com.pulumi.aws.oam.kotlin.inputs.GetLinkPlainArgsBuilder
import com.pulumi.aws.oam.kotlin.inputs.GetSinkPlainArgs
import com.pulumi.aws.oam.kotlin.inputs.GetSinkPlainArgsBuilder
import com.pulumi.aws.oam.kotlin.outputs.GetLinkResult
import com.pulumi.aws.oam.kotlin.outputs.GetLinksResult
import com.pulumi.aws.oam.kotlin.outputs.GetSinkResult
import com.pulumi.aws.oam.kotlin.outputs.GetSinksResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.oam.kotlin.outputs.GetLinkResult.Companion.toKotlin as getLinkResultToKotlin
import com.pulumi.aws.oam.kotlin.outputs.GetLinksResult.Companion.toKotlin as getLinksResultToKotlin
import com.pulumi.aws.oam.kotlin.outputs.GetSinkResult.Companion.toKotlin as getSinkResultToKotlin
import com.pulumi.aws.oam.kotlin.outputs.GetSinksResult.Companion.toKotlin as getSinksResultToKotlin

public object OamFunctions {
    /**
     * Data source for managing an AWS CloudWatch Observability Access Manager Link.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.oam.getLink({
     *     linkIdentifier: "arn:aws:oam:us-west-1:111111111111:link/abcd1234-a123-456a-a12b-a123b456c789",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.oam.get_link(link_identifier="arn:aws:oam:us-west-1:111111111111:link/abcd1234-a123-456a-a12b-a123b456c789")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Oam.GetLink.Invoke(new()
     *     {
     *         LinkIdentifier = "arn:aws:oam:us-west-1:111111111111:link/abcd1234-a123-456a-a12b-a123b456c789",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := oam.LookupLink(ctx, &oam.LookupLinkArgs{
     * 			LinkIdentifier: "arn:aws:oam:us-west-1:111111111111:link/abcd1234-a123-456a-a12b-a123b456c789",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import com.pulumi.aws.oam.inputs.GetLinkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getLink(GetLinkArgs.builder()
     *             .linkIdentifier("arn:aws:oam:us-west-1:111111111111:link/abcd1234-a123-456a-a12b-a123b456c789")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:oam:getLink
     *       Arguments:
     *         linkIdentifier: arn:aws:oam:us-west-1:111111111111:link/abcd1234-a123-456a-a12b-a123b456c789
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLink.
     * @return A collection of values returned by getLink.
     */
    public suspend fun getLink(argument: GetLinkPlainArgs): GetLinkResult =
        getLinkResultToKotlin(getLinkPlain(argument.toJava()).await())

    /**
     * @see [getLink].
     * @param linkIdentifier ARN of the link.
     * @param tags
     * @return A collection of values returned by getLink.
     */
    public suspend fun getLink(linkIdentifier: String, tags: Map<String, String>? = null): GetLinkResult {
        val argument = GetLinkPlainArgs(
            linkIdentifier = linkIdentifier,
            tags = tags,
        )
        return getLinkResultToKotlin(getLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getLink].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;oam&#46;kotlin&#46;inputs&#46;GetLinkPlainArgs].
     * @return A collection of values returned by getLink.
     */
    public suspend fun getLink(argument: suspend GetLinkPlainArgsBuilder.() -> Unit): GetLinkResult {
        val builder = GetLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkResultToKotlin(getLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS CloudWatch Observability Access Manager Links.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.oam.getLinks({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.oam.get_links()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Oam.GetLinks.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := oam.GetLinks(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getLinks();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:oam:getLinks
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Data source for managing an AWS CloudWatch Observability Access Manager Links.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.oam.getLinks({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.oam.get_links()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Oam.GetLinks.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := oam.GetLinks(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getLinks();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:oam:getLinks
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getLinks.
     */
    public suspend fun getLinks(): GetLinksResult = getLinksResultToKotlin(getLinksPlain().await())

    /**
     * Data source for managing an AWS CloudWatch Observability Access Manager Sink.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.oam.getSink({
     *     sinkIdentifier: "arn:aws:oam:us-west-1:111111111111:sink/abcd1234-a123-456a-a12b-a123b456c789",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.oam.get_sink(sink_identifier="arn:aws:oam:us-west-1:111111111111:sink/abcd1234-a123-456a-a12b-a123b456c789")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Oam.GetSink.Invoke(new()
     *     {
     *         SinkIdentifier = "arn:aws:oam:us-west-1:111111111111:sink/abcd1234-a123-456a-a12b-a123b456c789",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := oam.LookupSink(ctx, &oam.LookupSinkArgs{
     * 			SinkIdentifier: "arn:aws:oam:us-west-1:111111111111:sink/abcd1234-a123-456a-a12b-a123b456c789",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import com.pulumi.aws.oam.inputs.GetSinkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getSink(GetSinkArgs.builder()
     *             .sinkIdentifier("arn:aws:oam:us-west-1:111111111111:sink/abcd1234-a123-456a-a12b-a123b456c789")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:oam:getSink
     *       Arguments:
     *         sinkIdentifier: arn:aws:oam:us-west-1:111111111111:sink/abcd1234-a123-456a-a12b-a123b456c789
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSink.
     * @return A collection of values returned by getSink.
     */
    public suspend fun getSink(argument: GetSinkPlainArgs): GetSinkResult =
        getSinkResultToKotlin(getSinkPlain(argument.toJava()).await())

    /**
     * @see [getSink].
     * @param sinkIdentifier ARN of the sink.
     * @param tags Tags assigned to the sink.
     * @return A collection of values returned by getSink.
     */
    public suspend fun getSink(sinkIdentifier: String, tags: Map<String, String>? = null): GetSinkResult {
        val argument = GetSinkPlainArgs(
            sinkIdentifier = sinkIdentifier,
            tags = tags,
        )
        return getSinkResultToKotlin(getSinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getSink].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;oam&#46;kotlin&#46;inputs&#46;GetSinkPlainArgs].
     * @return A collection of values returned by getSink.
     */
    public suspend fun getSink(argument: suspend GetSinkPlainArgsBuilder.() -> Unit): GetSinkResult {
        val builder = GetSinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSinkResultToKotlin(getSinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS CloudWatch Observability Access Manager Sinks.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.oam.getSinks({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.oam.get_sinks()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Oam.GetSinks.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := oam.GetSinks(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getSinks();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:oam:getSinks
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Data source for managing an AWS CloudWatch Observability Access Manager Sinks.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.oam.getSinks({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.oam.get_sinks()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Oam.GetSinks.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := oam.GetSinks(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.oam.OamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OamFunctions.getSinks();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:oam:getSinks
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getSinks.
     */
    public suspend fun getSinks(): GetSinksResult = getSinksResultToKotlin(getSinksPlain().await())
}
