@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Sink].
 */
@PulumiTagMarker
public class SinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SinkArgs = SinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SinkArgsBuilder.() -> Unit) {
        val builder = SinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Sink {
        val builtJavaResource = com.pulumi.aws.oam.Sink(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Sink(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS CloudWatch Observability Access Manager Sink.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.oam.Sink("example", {
 *     name: "ExampleSink",
 *     tags: {
 *         Env: "prod",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.oam.Sink("example",
 *     name="ExampleSink",
 *     tags={
 *         "Env": "prod",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Oam.Sink("example", new()
 *     {
 *         Name = "ExampleSink",
 *         Tags =
 *         {
 *             { "Env", "prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := oam.NewSink(ctx, "example", &oam.SinkArgs{
 * 			Name: pulumi.String("ExampleSink"),
 * 			Tags: pulumi.StringMap{
 * 				"Env": pulumi.String("prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Sink;
 * import com.pulumi.aws.oam.SinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Sink("example", SinkArgs.builder()
 *             .name("ExampleSink")
 *             .tags(Map.of("Env", "prod"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:oam:Sink
 *     properties:
 *       name: ExampleSink
 *       tags:
 *         Env: prod
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Observability Access Manager Sink using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:oam/sink:Sink example arn:aws:oam:us-west-2:123456789012:sink/sink-id
 * ```
 */
public class Sink internal constructor(
    override val javaResource: com.pulumi.aws.oam.Sink,
) : KotlinCustomResource(javaResource, SinkMapper) {
    /**
     * ARN of the Sink.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name for the sink.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ID string that AWS generated as part of the sink ARN.
     */
    public val sinkId: Output<String>
        get() = javaResource.sinkId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SinkMapper : ResourceMapper<Sink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.oam.Sink::class == javaResource::class

    override fun map(javaResource: Resource): Sink = Sink(javaResource as com.pulumi.aws.oam.Sink)
}

/**
 * @see [Sink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Sink].
 */
public suspend fun sink(name: String, block: suspend SinkResourceBuilder.() -> Unit): Sink {
    val builder = SinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Sink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sink(name: String): Sink {
    val builder = SinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
