@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SinkPolicy].
 */
@PulumiTagMarker
public class SinkPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SinkPolicyArgs = SinkPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SinkPolicyArgsBuilder.() -> Unit) {
        val builder = SinkPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SinkPolicy {
        val builtJavaResource = com.pulumi.aws.oam.SinkPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SinkPolicy(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS CloudWatch Observability Access Manager Sink Policy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.oam.Sink("example", {name: "ExampleSink"});
 * const exampleSinkPolicy = new aws.oam.SinkPolicy("example", {
 *     sinkIdentifier: example.id,
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: [
 *                 "oam:CreateLink",
 *                 "oam:UpdateLink",
 *             ],
 *             Effect: "Allow",
 *             Resource: "*",
 *             Principal: {
 *                 AWS: [
 *                     "1111111111111",
 *                     "222222222222",
 *                 ],
 *             },
 *             Condition: {
 *                 "ForAllValues:StringEquals": {
 *                     "oam:ResourceTypes": [
 *                         "AWS::CloudWatch::Metric",
 *                         "AWS::Logs::LogGroup",
 *                     ],
 *                 },
 *             },
 *         }],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.oam.Sink("example", name="ExampleSink")
 * example_sink_policy = aws.oam.SinkPolicy("example",
 *     sink_identifier=example.id,
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": [
 *                 "oam:CreateLink",
 *                 "oam:UpdateLink",
 *             ],
 *             "Effect": "Allow",
 *             "Resource": "*",
 *             "Principal": {
 *                 "AWS": [
 *                     "1111111111111",
 *                     "222222222222",
 *                 ],
 *             },
 *             "Condition": {
 *                 "ForAllValues:StringEquals": {
 *                     "oam:ResourceTypes": [
 *                         "AWS::CloudWatch::Metric",
 *                         "AWS::Logs::LogGroup",
 *                     ],
 *                 },
 *             },
 *         }],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Oam.Sink("example", new()
 *     {
 *         Name = "ExampleSink",
 *     });
 *     var exampleSinkPolicy = new Aws.Oam.SinkPolicy("example", new()
 *     {
 *         SinkIdentifier = example.Id,
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "oam:CreateLink",
 *                         "oam:UpdateLink",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Resource"] = "*",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["AWS"] = new[]
 *                         {
 *                             "1111111111111",
 *                             "222222222222",
 *                         },
 *                     },
 *                     ["Condition"] = new Dictionary<string, object?>
 *                     {
 *                         ["ForAllValues:StringEquals"] = new Dictionary<string, object?>
 *                         {
 *                             ["oam:ResourceTypes"] = new[]
 *                             {
 *                                 "AWS::CloudWatch::Metric",
 *                                 "AWS::Logs::LogGroup",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := oam.NewSink(ctx, "example", &oam.SinkArgs{
 * 			Name: pulumi.String("ExampleSink"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"oam:CreateLink",
 * 						"oam:UpdateLink",
 * 					},
 * 					"Effect":   "Allow",
 * 					"Resource": "*",
 * 					"Principal": map[string]interface{}{
 * 						"AWS": []string{
 * 							"1111111111111",
 * 							"222222222222",
 * 						},
 * 					},
 * 					"Condition": map[string]interface{}{
 * 						"ForAllValues:StringEquals": map[string]interface{}{
 * 							"oam:ResourceTypes": []string{
 * 								"AWS::CloudWatch::Metric",
 * 								"AWS::Logs::LogGroup",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = oam.NewSinkPolicy(ctx, "example", &oam.SinkPolicyArgs{
 * 			SinkIdentifier: example.ID(),
 * 			Policy:         pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Sink;
 * import com.pulumi.aws.oam.SinkArgs;
 * import com.pulumi.aws.oam.SinkPolicy;
 * import com.pulumi.aws.oam.SinkPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Sink("example", SinkArgs.builder()
 *             .name("ExampleSink")
 *             .build());
 *         var exampleSinkPolicy = new SinkPolicy("exampleSinkPolicy", SinkPolicyArgs.builder()
 *             .sinkIdentifier(example.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "oam:CreateLink",
 *                             "oam:UpdateLink"
 *                         )),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", jsonArray(
 *                                 "1111111111111",
 *                                 "222222222222"
 *                             ))
 *                         )),
 *                         jsonProperty("Condition", jsonObject(
 *                             jsonProperty("ForAllValues:StringEquals", jsonObject(
 *                                 jsonProperty("oam:ResourceTypes", jsonArray(
 *                                     "AWS::CloudWatch::Metric",
 *                                     "AWS::Logs::LogGroup"
 *                                 ))
 *                             ))
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:oam:Sink
 *     properties:
 *       name: ExampleSink
 *   exampleSinkPolicy:
 *     type: aws:oam:SinkPolicy
 *     name: example
 *     properties:
 *       sinkIdentifier: ${example.id}
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - oam:CreateLink
 *                 - oam:UpdateLink
 *               Effect: Allow
 *               Resource: '*'
 *               Principal:
 *                 AWS:
 *                   - '1111111111111'
 *                   - '222222222222'
 *               Condition:
 *                 ForAllValues:StringEquals:
 *                   oam:ResourceTypes:
 *                     - AWS::CloudWatch::Metric
 *                     - AWS::Logs::LogGroup
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Observability Access Manager Sink Policy using the `sink_identifier`. For example:
 * ```sh
 * $ pulumi import aws:oam/sinkPolicy:SinkPolicy example arn:aws:oam:us-west-2:123456789012:sink/sink-id
 * ```
 */
public class SinkPolicy internal constructor(
    override val javaResource: com.pulumi.aws.oam.SinkPolicy,
) : KotlinCustomResource(javaResource, SinkPolicyMapper) {
    /**
     * ARN of the Sink.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * JSON policy to use. If you are updating an existing policy, the entire existing policy is replaced by what you specify here.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * ID string that AWS generated as part of the sink ARN.
     */
    public val sinkId: Output<String>
        get() = javaResource.sinkId().applyValue({ args0 -> args0 })

    /**
     * ARN of the sink to attach this policy to.
     */
    public val sinkIdentifier: Output<String>
        get() = javaResource.sinkIdentifier().applyValue({ args0 -> args0 })
}

public object SinkPolicyMapper : ResourceMapper<SinkPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.oam.SinkPolicy::class == javaResource::class

    override fun map(javaResource: Resource): SinkPolicy = SinkPolicy(
        javaResource as
            com.pulumi.aws.oam.SinkPolicy,
    )
}

/**
 * @see [SinkPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SinkPolicy].
 */
public suspend fun sinkPolicy(name: String, block: suspend SinkPolicyResourceBuilder.() -> Unit): SinkPolicy {
    val builder = SinkPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SinkPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sinkPolicy(name: String): SinkPolicy {
    val builder = SinkPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
