@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin

import com.pulumi.aws.oam.SinkPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CloudWatch Observability Access Manager Sink Policy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.oam.Sink("example", {name: "ExampleSink"});
 * const exampleSinkPolicy = new aws.oam.SinkPolicy("example", {
 *     sinkIdentifier: example.id,
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: [
 *                 "oam:CreateLink",
 *                 "oam:UpdateLink",
 *             ],
 *             Effect: "Allow",
 *             Resource: "*",
 *             Principal: {
 *                 AWS: [
 *                     "1111111111111",
 *                     "222222222222",
 *                 ],
 *             },
 *             Condition: {
 *                 "ForAllValues:StringEquals": {
 *                     "oam:ResourceTypes": [
 *                         "AWS::CloudWatch::Metric",
 *                         "AWS::Logs::LogGroup",
 *                     ],
 *                 },
 *             },
 *         }],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.oam.Sink("example", name="ExampleSink")
 * example_sink_policy = aws.oam.SinkPolicy("example",
 *     sink_identifier=example.id,
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": [
 *                 "oam:CreateLink",
 *                 "oam:UpdateLink",
 *             ],
 *             "Effect": "Allow",
 *             "Resource": "*",
 *             "Principal": {
 *                 "AWS": [
 *                     "1111111111111",
 *                     "222222222222",
 *                 ],
 *             },
 *             "Condition": {
 *                 "ForAllValues:StringEquals": {
 *                     "oam:ResourceTypes": [
 *                         "AWS::CloudWatch::Metric",
 *                         "AWS::Logs::LogGroup",
 *                     ],
 *                 },
 *             },
 *         }],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Oam.Sink("example", new()
 *     {
 *         Name = "ExampleSink",
 *     });
 *     var exampleSinkPolicy = new Aws.Oam.SinkPolicy("example", new()
 *     {
 *         SinkIdentifier = example.Id,
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "oam:CreateLink",
 *                         "oam:UpdateLink",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Resource"] = "*",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["AWS"] = new[]
 *                         {
 *                             "1111111111111",
 *                             "222222222222",
 *                         },
 *                     },
 *                     ["Condition"] = new Dictionary<string, object?>
 *                     {
 *                         ["ForAllValues:StringEquals"] = new Dictionary<string, object?>
 *                         {
 *                             ["oam:ResourceTypes"] = new[]
 *                             {
 *                                 "AWS::CloudWatch::Metric",
 *                                 "AWS::Logs::LogGroup",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/oam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := oam.NewSink(ctx, "example", &oam.SinkArgs{
 * 			Name: pulumi.String("ExampleSink"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"oam:CreateLink",
 * 						"oam:UpdateLink",
 * 					},
 * 					"Effect":   "Allow",
 * 					"Resource": "*",
 * 					"Principal": map[string]interface{}{
 * 						"AWS": []string{
 * 							"1111111111111",
 * 							"222222222222",
 * 						},
 * 					},
 * 					"Condition": map[string]interface{}{
 * 						"ForAllValues:StringEquals": map[string]interface{}{
 * 							"oam:ResourceTypes": []string{
 * 								"AWS::CloudWatch::Metric",
 * 								"AWS::Logs::LogGroup",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = oam.NewSinkPolicy(ctx, "example", &oam.SinkPolicyArgs{
 * 			SinkIdentifier: example.ID(),
 * 			Policy:         pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Sink;
 * import com.pulumi.aws.oam.SinkArgs;
 * import com.pulumi.aws.oam.SinkPolicy;
 * import com.pulumi.aws.oam.SinkPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Sink("example", SinkArgs.builder()
 *             .name("ExampleSink")
 *             .build());
 *         var exampleSinkPolicy = new SinkPolicy("exampleSinkPolicy", SinkPolicyArgs.builder()
 *             .sinkIdentifier(example.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "oam:CreateLink",
 *                             "oam:UpdateLink"
 *                         )),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", jsonArray(
 *                                 "1111111111111",
 *                                 "222222222222"
 *                             ))
 *                         )),
 *                         jsonProperty("Condition", jsonObject(
 *                             jsonProperty("ForAllValues:StringEquals", jsonObject(
 *                                 jsonProperty("oam:ResourceTypes", jsonArray(
 *                                     "AWS::CloudWatch::Metric",
 *                                     "AWS::Logs::LogGroup"
 *                                 ))
 *                             ))
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:oam:Sink
 *     properties:
 *       name: ExampleSink
 *   exampleSinkPolicy:
 *     type: aws:oam:SinkPolicy
 *     name: example
 *     properties:
 *       sinkIdentifier: ${example.id}
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - oam:CreateLink
 *                 - oam:UpdateLink
 *               Effect: Allow
 *               Resource: '*'
 *               Principal:
 *                 AWS:
 *                   - '1111111111111'
 *                   - '222222222222'
 *               Condition:
 *                 ForAllValues:StringEquals:
 *                   oam:ResourceTypes:
 *                     - AWS::CloudWatch::Metric
 *                     - AWS::Logs::LogGroup
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Observability Access Manager Sink Policy using the `sink_identifier`. For example:
 * ```sh
 * $ pulumi import aws:oam/sinkPolicy:SinkPolicy example arn:aws:oam:us-west-2:123456789012:sink/sink-id
 * ```
 * @property policy JSON policy to use. If you are updating an existing policy, the entire existing policy is replaced by what you specify here.
 * @property sinkIdentifier ARN of the sink to attach this policy to.
 */
public data class SinkPolicyArgs(
    public val policy: Output<String>? = null,
    public val sinkIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.oam.SinkPolicyArgs> {
    override fun toJava(): com.pulumi.aws.oam.SinkPolicyArgs =
        com.pulumi.aws.oam.SinkPolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .sinkIdentifier(sinkIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SinkPolicyArgs].
 */
@PulumiTagMarker
public class SinkPolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var sinkIdentifier: Output<String>? = null

    /**
     * @param value JSON policy to use. If you are updating an existing policy, the entire existing policy is replaced by what you specify here.
     */
    @JvmName("ybdcwmiwcnrcupqh")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value ARN of the sink to attach this policy to.
     */
    @JvmName("ngtmpjfclmkifkhl")
    public suspend fun sinkIdentifier(`value`: Output<String>) {
        this.sinkIdentifier = value
    }

    /**
     * @param value JSON policy to use. If you are updating an existing policy, the entire existing policy is replaced by what you specify here.
     */
    @JvmName("vecxbnywsdqqxqvv")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value ARN of the sink to attach this policy to.
     */
    @JvmName("incboykrsebxcfdn")
    public suspend fun sinkIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkIdentifier = mapped
    }

    internal fun build(): SinkPolicyArgs = SinkPolicyArgs(
        policy = policy,
        sinkIdentifier = sinkIdentifier,
    )
}
