@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin.inputs

import com.pulumi.aws.oam.inputs.LinkLinkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property logGroupConfiguration Configuration for filtering which log groups are to send log events from the source account to the monitoring account. See `log_group_configuration` Block for details.
 * @property metricConfiguration Configuration for filtering which metric namespaces are to be shared from the source account to the monitoring account. See `metric_configuration` Block for details.
 */
public data class LinkLinkConfigurationArgs(
    public val logGroupConfiguration: Output<LinkLinkConfigurationLogGroupConfigurationArgs>? = null,
    public val metricConfiguration: Output<LinkLinkConfigurationMetricConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.oam.inputs.LinkLinkConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.oam.inputs.LinkLinkConfigurationArgs =
        com.pulumi.aws.oam.inputs.LinkLinkConfigurationArgs.builder()
            .logGroupConfiguration(
                logGroupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .metricConfiguration(
                metricConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LinkLinkConfigurationArgs].
 */
@PulumiTagMarker
public class LinkLinkConfigurationArgsBuilder internal constructor() {
    private var logGroupConfiguration: Output<LinkLinkConfigurationLogGroupConfigurationArgs>? = null

    private var metricConfiguration: Output<LinkLinkConfigurationMetricConfigurationArgs>? = null

    /**
     * @param value Configuration for filtering which log groups are to send log events from the source account to the monitoring account. See `log_group_configuration` Block for details.
     */
    @JvmName("ambtooaxsilyqjhu")
    public suspend fun logGroupConfiguration(`value`: Output<LinkLinkConfigurationLogGroupConfigurationArgs>) {
        this.logGroupConfiguration = value
    }

    /**
     * @param value Configuration for filtering which metric namespaces are to be shared from the source account to the monitoring account. See `metric_configuration` Block for details.
     */
    @JvmName("jbqidngtydngpgoe")
    public suspend fun metricConfiguration(`value`: Output<LinkLinkConfigurationMetricConfigurationArgs>) {
        this.metricConfiguration = value
    }

    /**
     * @param value Configuration for filtering which log groups are to send log events from the source account to the monitoring account. See `log_group_configuration` Block for details.
     */
    @JvmName("jileitcangpnbumu")
    public suspend fun logGroupConfiguration(`value`: LinkLinkConfigurationLogGroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupConfiguration = mapped
    }

    /**
     * @param argument Configuration for filtering which log groups are to send log events from the source account to the monitoring account. See `log_group_configuration` Block for details.
     */
    @JvmName("snpdfkihlmxopjwc")
    public suspend fun logGroupConfiguration(argument: suspend LinkLinkConfigurationLogGroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LinkLinkConfigurationLogGroupConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.logGroupConfiguration = mapped
    }

    /**
     * @param value Configuration for filtering which metric namespaces are to be shared from the source account to the monitoring account. See `metric_configuration` Block for details.
     */
    @JvmName("csswufespryvhupr")
    public suspend fun metricConfiguration(`value`: LinkLinkConfigurationMetricConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricConfiguration = mapped
    }

    /**
     * @param argument Configuration for filtering which metric namespaces are to be shared from the source account to the monitoring account. See `metric_configuration` Block for details.
     */
    @JvmName("amphkmexciqbdokc")
    public suspend fun metricConfiguration(argument: suspend LinkLinkConfigurationMetricConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LinkLinkConfigurationMetricConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.metricConfiguration = mapped
    }

    internal fun build(): LinkLinkConfigurationArgs = LinkLinkConfigurationArgs(
        logGroupConfiguration = logGroupConfiguration,
        metricConfiguration = metricConfiguration,
    )
}
