@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin.inputs

import com.pulumi.aws.oam.inputs.LinkLinkConfigurationLogGroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property filter Filter string that specifies which log groups are to share their log events with the monitoring account. See [LogGroupConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_LogGroupConfiguration.html) for details.
 */
public data class LinkLinkConfigurationLogGroupConfigurationArgs(
    public val filter: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.oam.inputs.LinkLinkConfigurationLogGroupConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.oam.inputs.LinkLinkConfigurationLogGroupConfigurationArgs =
        com.pulumi.aws.oam.inputs.LinkLinkConfigurationLogGroupConfigurationArgs.builder()
            .filter(filter.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkLinkConfigurationLogGroupConfigurationArgs].
 */
@PulumiTagMarker
public class LinkLinkConfigurationLogGroupConfigurationArgsBuilder internal constructor() {
    private var filter: Output<String>? = null

    /**
     * @param value Filter string that specifies which log groups are to share their log events with the monitoring account. See [LogGroupConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_LogGroupConfiguration.html) for details.
     */
    @JvmName("odpaefbiwhnvmowo")
    public suspend fun filter(`value`: Output<String>) {
        this.filter = value
    }

    /**
     * @param value Filter string that specifies which log groups are to share their log events with the monitoring account. See [LogGroupConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_LogGroupConfiguration.html) for details.
     */
    @JvmName("jnsaqhbyepvvrbho")
    public suspend fun filter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    internal fun build(): LinkLinkConfigurationLogGroupConfigurationArgs =
        LinkLinkConfigurationLogGroupConfigurationArgs(
            filter = filter ?: throw PulumiNullFieldException("filter"),
        )
}
