@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin.inputs

import com.pulumi.aws.oam.inputs.LinkLinkConfigurationMetricConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property filter Filter string that specifies  which metrics are to be shared with the monitoring account. See [MetricConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_MetricConfiguration.html) for details.
 */
public data class LinkLinkConfigurationMetricConfigurationArgs(
    public val filter: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.oam.inputs.LinkLinkConfigurationMetricConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.oam.inputs.LinkLinkConfigurationMetricConfigurationArgs =
        com.pulumi.aws.oam.inputs.LinkLinkConfigurationMetricConfigurationArgs.builder()
            .filter(filter.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkLinkConfigurationMetricConfigurationArgs].
 */
@PulumiTagMarker
public class LinkLinkConfigurationMetricConfigurationArgsBuilder internal constructor() {
    private var filter: Output<String>? = null

    /**
     * @param value Filter string that specifies  which metrics are to be shared with the monitoring account. See [MetricConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_MetricConfiguration.html) for details.
     */
    @JvmName("uouibvlojrbdjpxl")
    public suspend fun filter(`value`: Output<String>) {
        this.filter = value
    }

    /**
     * @param value Filter string that specifies  which metrics are to be shared with the monitoring account. See [MetricConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_MetricConfiguration.html) for details.
     */
    @JvmName("xdolmlgmqjuwisms")
    public suspend fun filter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    internal fun build(): LinkLinkConfigurationMetricConfigurationArgs =
        LinkLinkConfigurationMetricConfigurationArgs(
            filter = filter ?: throw PulumiNullFieldException("filter"),
        )
}
