@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property logGroupConfigurations Configuration for filtering which log groups are to send log events from the source account to the monitoring account. See `log_group_configuration` Block for details.
 * @property metricConfigurations Configuration for filtering which metric namespaces are to be shared from the source account to the monitoring account. See `metric_configuration` Block for details.
 */
public data class GetLinkLinkConfiguration(
    public val logGroupConfigurations: List<GetLinkLinkConfigurationLogGroupConfiguration>,
    public val metricConfigurations: List<GetLinkLinkConfigurationMetricConfiguration>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.oam.outputs.GetLinkLinkConfiguration): GetLinkLinkConfiguration = GetLinkLinkConfiguration(
            logGroupConfigurations = javaType.logGroupConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.oam.kotlin.outputs.GetLinkLinkConfigurationLogGroupConfiguration.Companion.toKotlin(args0)
                })
            }),
            metricConfigurations = javaType.metricConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.oam.kotlin.outputs.GetLinkLinkConfigurationMetricConfiguration.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
