@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLink.
 * @property arn ARN of the link.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property label Label that is assigned to this link.
 * @property labelTemplate Human-readable name used to identify this source account when you are viewing data from it in the monitoring account.
 * @property linkConfigurations Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
 * @property linkId ID string that AWS generated as part of the link ARN.
 * @property linkIdentifier
 * @property resourceTypes Types of data that the source account shares with the monitoring account.
 * @property sinkArn ARN of the sink that is used for this link.
 * @property tags
 */
public data class GetLinkResult(
    public val arn: String,
    public val id: String,
    public val label: String,
    public val labelTemplate: String,
    public val linkConfigurations: List<GetLinkLinkConfiguration>,
    public val linkId: String,
    public val linkIdentifier: String,
    public val resourceTypes: List<String>,
    public val sinkArn: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.oam.outputs.GetLinkResult): GetLinkResult =
            GetLinkResult(
                arn = javaType.arn(),
                id = javaType.id(),
                label = javaType.label(),
                labelTemplate = javaType.labelTemplate(),
                linkConfigurations = javaType.linkConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.oam.kotlin.outputs.GetLinkLinkConfiguration.Companion.toKotlin(args0)
                    })
                }),
                linkId = javaType.linkId(),
                linkIdentifier = javaType.linkIdentifier(),
                resourceTypes = javaType.resourceTypes().map({ args0 -> args0 }),
                sinkArn = javaType.sinkArn(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
