@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property logGroupConfiguration Configuration for filtering which log groups are to send log events from the source account to the monitoring account. See `log_group_configuration` Block for details.
 * @property metricConfiguration Configuration for filtering which metric namespaces are to be shared from the source account to the monitoring account. See `metric_configuration` Block for details.
 */
public data class LinkLinkConfiguration(
    public val logGroupConfiguration: LinkLinkConfigurationLogGroupConfiguration? = null,
    public val metricConfiguration: LinkLinkConfigurationMetricConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.oam.outputs.LinkLinkConfiguration): LinkLinkConfiguration = LinkLinkConfiguration(
            logGroupConfiguration = javaType.logGroupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.oam.kotlin.outputs.LinkLinkConfigurationLogGroupConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            metricConfiguration = javaType.metricConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.oam.kotlin.outputs.LinkLinkConfigurationMetricConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
