@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.oam.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property filter Filter string that specifies which log groups are to share their log events with the monitoring account. See [LogGroupConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_LogGroupConfiguration.html) for details.
 */
public data class LinkLinkConfigurationLogGroupConfiguration(
    public val filter: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.oam.outputs.LinkLinkConfigurationLogGroupConfiguration): LinkLinkConfigurationLogGroupConfiguration = LinkLinkConfigurationLogGroupConfiguration(
            filter = javaType.filter(),
        )
    }
}
