@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainPolicy].
 */
@PulumiTagMarker
public class DomainPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainPolicyArgs = DomainPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainPolicyArgsBuilder.() -> Unit) {
        val builder = DomainPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainPolicy {
        val builtJavaResource = com.pulumi.aws.opensearch.DomainPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainPolicy(builtJavaResource)
    }
}

/**
 * Allows setting policy to an OpenSearch domain while referencing domain attributes (e.g., ARN).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.opensearch.Domain("example", {
 *     domainName: "tf-test",
 *     engineVersion: "OpenSearch_1.1",
 * });
 * const main = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "*",
 *             identifiers: ["*"],
 *         }],
 *         actions: ["es:*"],
 *         resources: [pulumi&#46;interpolate`${example&#46;arn}/*`],
 *         conditions: [{
 *             test: "IpAddress",
 *             variable: "aws:SourceIp",
 *             values: ["127&#46;0&#46;0&#46;1/32"],
 *         }],
 *     }],
 * });
 * const mainDomainPolicy = new aws.opensearch.DomainPolicy("main", {
 *     domainName: example.domainName,
 *     accessPolicies: main.apply(main => main.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.opensearch.Domain("example",
 *     domain_name="tf-test",
 *     engine_version="OpenSearch_1.1")
 * main = aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "*",
 *         "identifiers": ["*"],
 *     }],
 *     "actions": ["es:*"],
 *     "resources": [example&#46;arn&#46;apply(lambda arn: f"{arn}/*")],
 *     "conditions": [{
 *         "test": "IpAddress",
 *         "variable": "aws:SourceIp",
 *         "values": ["127&#46;0&#46;0&#46;1/32"],
 *     }],
 * }])
 * main_domain_policy = aws.opensearch.DomainPolicy("main",
 *     domain_name=example.domain_name,
 *     access_policies=main.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.OpenSearch.Domain("example", new()
 *     {
 *         DomainName = "tf-test",
 *         EngineVersion = "OpenSearch_1.1",
 *     });
 *     var main = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "*",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "es:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     $"{example.Arn}/*",
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "IpAddress",
 *                         Variable = "aws:SourceIp",
 *                         Values = new[]
 *                         {
 *                             "127.0.0.1/32",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var mainDomainPolicy = new Aws.OpenSearch.DomainPolicy("main", new()
 *     {
 *         DomainName = example.DomainName,
 *         AccessPolicies = main.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := opensearch.NewDomain(ctx, "example", &opensearch.DomainArgs{
 * 			DomainName:    pulumi.String("tf-test"),
 * 			EngineVersion: pulumi.String("OpenSearch_1.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		main := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Principals: iam.GetPolicyDocumentStatementPrincipalArray{
 * 						&iam.GetPolicyDocumentStatementPrincipalArgs{
 * 							Type: pulumi.String("*"),
 * 							Identifiers: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 						},
 * 					},
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("es:*"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						example.Arn.ApplyT(func(arn string) (string, error) {
 * 							return fmt.Sprintf("%v/*", arn), nil
 * 						}).(pulumi.StringOutput),
 * 					},
 * 					Conditions: iam.GetPolicyDocumentStatementConditionArray{
 * 						&iam.GetPolicyDocumentStatementConditionArgs{
 * 							Test:     pulumi.String("IpAddress"),
 * 							Variable: pulumi.String("aws:SourceIp"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("127.0.0.1/32"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = opensearch.NewDomainPolicy(ctx, "main", &opensearch.DomainPolicyArgs{
 * 			DomainName: example.DomainName,
 * 			AccessPolicies: pulumi.String(main.ApplyT(func(main iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &main.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.opensearch.DomainPolicy;
 * import com.pulumi.aws.opensearch.DomainPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .domainName("tf-test")
 *             .engineVersion("OpenSearch_1.1")
 *             .build());
 *         final var main = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("es:*")
 *                 .resources(example.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("IpAddress")
 *                     .variable("aws:SourceIp")
 *                     .values("127.0.0.1/32")
 *                     .build())
 *                 .build())
 *             .build());
 *         var mainDomainPolicy = new DomainPolicy("mainDomainPolicy", DomainPolicyArgs.builder()
 *             .domainName(example.domainName())
 *             .accessPolicies(main.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(main -> main.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:opensearch:Domain
 *     properties:
 *       domainName: tf-test
 *       engineVersion: OpenSearch_1.1
 *   mainDomainPolicy:
 *     type: aws:opensearch:DomainPolicy
 *     name: main
 *     properties:
 *       domainName: ${example.domainName}
 *       accessPolicies: ${main.json}
 * variables:
 *   main:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: '*'
 *                 identifiers:
 *                   - '*'
 *             actions:
 *               - es:*
 *             resources:
 *               - ${example.arn}/*
 *             conditions:
 *               - test: IpAddress
 *                 variable: aws:SourceIp
 *                 values:
 *                   - 127.0.0.1/32
 * ```
 * <!--End PulumiCodeChooser -->
 * */*/*/*/*/*/
 */
public class DomainPolicy internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.DomainPolicy,
) : KotlinCustomResource(javaResource, DomainPolicyMapper) {
    /**
     * IAM policy document specifying the access policies for the domain
     */
    public val accessPolicies: Output<String>
        get() = javaResource.accessPolicies().applyValue({ args0 -> args0 })

    /**
     * Name of the domain.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })
}

public object DomainPolicyMapper : ResourceMapper<DomainPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.DomainPolicy::class == javaResource::class

    override fun map(javaResource: Resource): DomainPolicy = DomainPolicy(
        javaResource as
            com.pulumi.aws.opensearch.DomainPolicy,
    )
}

/**
 * @see [DomainPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainPolicy].
 */
public suspend fun domainPolicy(
    name: String,
    block: suspend DomainPolicyResourceBuilder.() -> Unit,
): DomainPolicy {
    val builder = DomainPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainPolicy(name: String): DomainPolicy {
    val builder = DomainPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
