@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.DomainPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Allows setting policy to an OpenSearch domain while referencing domain attributes (e.g., ARN).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.opensearch.Domain("example", {
 *     domainName: "tf-test",
 *     engineVersion: "OpenSearch_1.1",
 * });
 * const main = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "*",
 *             identifiers: ["*"],
 *         }],
 *         actions: ["es:*"],
 *         resources: [pulumi&#46;interpolate`${example&#46;arn}/*`],
 *         conditions: [{
 *             test: "IpAddress",
 *             variable: "aws:SourceIp",
 *             values: ["127&#46;0&#46;0&#46;1/32"],
 *         }],
 *     }],
 * });
 * const mainDomainPolicy = new aws.opensearch.DomainPolicy("main", {
 *     domainName: example.domainName,
 *     accessPolicies: main.apply(main => main.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.opensearch.Domain("example",
 *     domain_name="tf-test",
 *     engine_version="OpenSearch_1.1")
 * main = aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "*",
 *         "identifiers": ["*"],
 *     }],
 *     "actions": ["es:*"],
 *     "resources": [example&#46;arn&#46;apply(lambda arn: f"{arn}/*")],
 *     "conditions": [{
 *         "test": "IpAddress",
 *         "variable": "aws:SourceIp",
 *         "values": ["127&#46;0&#46;0&#46;1/32"],
 *     }],
 * }])
 * main_domain_policy = aws.opensearch.DomainPolicy("main",
 *     domain_name=example.domain_name,
 *     access_policies=main.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.OpenSearch.Domain("example", new()
 *     {
 *         DomainName = "tf-test",
 *         EngineVersion = "OpenSearch_1.1",
 *     });
 *     var main = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "*",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "es:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     $"{example.Arn}/*",
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "IpAddress",
 *                         Variable = "aws:SourceIp",
 *                         Values = new[]
 *                         {
 *                             "127.0.0.1/32",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var mainDomainPolicy = new Aws.OpenSearch.DomainPolicy("main", new()
 *     {
 *         DomainName = example.DomainName,
 *         AccessPolicies = main.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := opensearch.NewDomain(ctx, "example", &opensearch.DomainArgs{
 * 			DomainName:    pulumi.String("tf-test"),
 * 			EngineVersion: pulumi.String("OpenSearch_1.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		main := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Principals: iam.GetPolicyDocumentStatementPrincipalArray{
 * 						&iam.GetPolicyDocumentStatementPrincipalArgs{
 * 							Type: pulumi.String("*"),
 * 							Identifiers: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 						},
 * 					},
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("es:*"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						example.Arn.ApplyT(func(arn string) (string, error) {
 * 							return fmt.Sprintf("%v/*", arn), nil
 * 						}).(pulumi.StringOutput),
 * 					},
 * 					Conditions: iam.GetPolicyDocumentStatementConditionArray{
 * 						&iam.GetPolicyDocumentStatementConditionArgs{
 * 							Test:     pulumi.String("IpAddress"),
 * 							Variable: pulumi.String("aws:SourceIp"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("127.0.0.1/32"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = opensearch.NewDomainPolicy(ctx, "main", &opensearch.DomainPolicyArgs{
 * 			DomainName: example.DomainName,
 * 			AccessPolicies: pulumi.String(main.ApplyT(func(main iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &main.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.opensearch.DomainPolicy;
 * import com.pulumi.aws.opensearch.DomainPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .domainName("tf-test")
 *             .engineVersion("OpenSearch_1.1")
 *             .build());
 *         final var main = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("es:*")
 *                 .resources(example.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("IpAddress")
 *                     .variable("aws:SourceIp")
 *                     .values("127.0.0.1/32")
 *                     .build())
 *                 .build())
 *             .build());
 *         var mainDomainPolicy = new DomainPolicy("mainDomainPolicy", DomainPolicyArgs.builder()
 *             .domainName(example.domainName())
 *             .accessPolicies(main.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(main -> main.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:opensearch:Domain
 *     properties:
 *       domainName: tf-test
 *       engineVersion: OpenSearch_1.1
 *   mainDomainPolicy:
 *     type: aws:opensearch:DomainPolicy
 *     name: main
 *     properties:
 *       domainName: ${example.domainName}
 *       accessPolicies: ${main.json}
 * variables:
 *   main:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: '*'
 *                 identifiers:
 *                   - '*'
 *             actions:
 *               - es:*
 *             resources:
 *               - ${example.arn}/*
 *             conditions:
 *               - test: IpAddress
 *                 variable: aws:SourceIp
 *                 values:
 *                   - 127.0.0.1/32
 * ```
 * <!--End PulumiCodeChooser -->
 * @property accessPolicies IAM policy document specifying the access policies for the domain
 * @property domainName Name of the domain.
 * */*/*/*/*/*/
 */
public data class DomainPolicyArgs(
    public val accessPolicies: Output<String>? = null,
    public val domainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.DomainPolicyArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.DomainPolicyArgs =
        com.pulumi.aws.opensearch.DomainPolicyArgs.builder()
            .accessPolicies(accessPolicies?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainPolicyArgs].
 */
@PulumiTagMarker
public class DomainPolicyArgsBuilder internal constructor() {
    private var accessPolicies: Output<String>? = null

    private var domainName: Output<String>? = null

    /**
     * @param value IAM policy document specifying the access policies for the domain
     */
    @JvmName("bsgafpbeymwroefb")
    public suspend fun accessPolicies(`value`: Output<String>) {
        this.accessPolicies = value
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("yijvfpyakewiopfi")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value IAM policy document specifying the access policies for the domain
     */
    @JvmName("mcybnhpxduagrnrx")
    public suspend fun accessPolicies(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("bfsatayfnwutashm")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    internal fun build(): DomainPolicyArgs = DomainPolicyArgs(
        accessPolicies = accessPolicies,
        domainName = domainName,
    )
}
