@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.OpensearchFunctions.getDomainPlain
import com.pulumi.aws.opensearch.OpensearchFunctions.getServerlessAccessPolicyPlain
import com.pulumi.aws.opensearch.OpensearchFunctions.getServerlessCollectionPlain
import com.pulumi.aws.opensearch.OpensearchFunctions.getServerlessLifecyclePolicyPlain
import com.pulumi.aws.opensearch.OpensearchFunctions.getServerlessSecurityConfigPlain
import com.pulumi.aws.opensearch.OpensearchFunctions.getServerlessSecurityPolicyPlain
import com.pulumi.aws.opensearch.OpensearchFunctions.getServerlessVpcEndpointPlain
import com.pulumi.aws.opensearch.kotlin.inputs.GetDomainOffPeakWindowOptions
import com.pulumi.aws.opensearch.kotlin.inputs.GetDomainPlainArgs
import com.pulumi.aws.opensearch.kotlin.inputs.GetDomainPlainArgsBuilder
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessAccessPolicyPlainArgs
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessAccessPolicyPlainArgsBuilder
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessCollectionPlainArgs
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessCollectionPlainArgsBuilder
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessLifecyclePolicyPlainArgs
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessLifecyclePolicyPlainArgsBuilder
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessSecurityConfigPlainArgs
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessSecurityConfigPlainArgsBuilder
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessSecurityConfigSamlOptions
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessSecurityPolicyPlainArgs
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessSecurityPolicyPlainArgsBuilder
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessVpcEndpointPlainArgs
import com.pulumi.aws.opensearch.kotlin.inputs.GetServerlessVpcEndpointPlainArgsBuilder
import com.pulumi.aws.opensearch.kotlin.outputs.GetDomainResult
import com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessAccessPolicyResult
import com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessCollectionResult
import com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessLifecyclePolicyResult
import com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessSecurityConfigResult
import com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessSecurityPolicyResult
import com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessVpcEndpointResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.opensearch.kotlin.outputs.GetDomainResult.Companion.toKotlin as getDomainResultToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessAccessPolicyResult.Companion.toKotlin as getServerlessAccessPolicyResultToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessCollectionResult.Companion.toKotlin as getServerlessCollectionResultToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessLifecyclePolicyResult.Companion.toKotlin as getServerlessLifecyclePolicyResultToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessSecurityConfigResult.Companion.toKotlin as getServerlessSecurityConfigResultToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessSecurityPolicyResult.Companion.toKotlin as getServerlessSecurityPolicyResultToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.GetServerlessVpcEndpointResult.Companion.toKotlin as getServerlessVpcEndpointResultToKotlin

public object OpensearchFunctions {
    /**
     * Use this data source to get information about an OpenSearch Domain
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const myDomain = aws.opensearch.getDomain({
     *     domainName: "my-domain-name",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * my_domain = aws.opensearch.get_domain(domain_name="my-domain-name")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var myDomain = Aws.OpenSearch.GetDomain.Invoke(new()
     *     {
     *         DomainName = "my-domain-name",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := opensearch.LookupDomain(ctx, &opensearch.LookupDomainArgs{
     * 			DomainName: "my-domain-name",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.opensearch.OpensearchFunctions;
     * import com.pulumi.aws.opensearch.inputs.GetDomainArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var myDomain = OpensearchFunctions.getDomain(GetDomainArgs.builder()
     *             .domainName("my-domain-name")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   myDomain:
     *     fn::invoke:
     *       Function: aws:opensearch:getDomain
     *       Arguments:
     *         domainName: my-domain-name
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomain.
     * @return A collection of values returned by getDomain.
     */
    public suspend fun getDomain(argument: GetDomainPlainArgs): GetDomainResult =
        getDomainResultToKotlin(getDomainPlain(argument.toJava()).await())

    /**
     * @see [getDomain].
     * @param domainName Name of the domain.
     * @param offPeakWindowOptions Off Peak update options
     * @param tags Tags assigned to the domain.
     * @return A collection of values returned by getDomain.
     */
    public suspend fun getDomain(
        domainName: String,
        offPeakWindowOptions: GetDomainOffPeakWindowOptions? = null,
        tags: Map<String, String>? = null,
    ): GetDomainResult {
        val argument = GetDomainPlainArgs(
            domainName = domainName,
            offPeakWindowOptions = offPeakWindowOptions,
            tags = tags,
        )
        return getDomainResultToKotlin(getDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomain].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;opensearch&#46;kotlin&#46;inputs&#46;GetDomainPlainArgs].
     * @return A collection of values returned by getDomain.
     */
    public suspend fun getDomain(argument: suspend GetDomainPlainArgsBuilder.() -> Unit): GetDomainResult {
        val builder = GetDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainResultToKotlin(getDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS OpenSearch Serverless Access Policy.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.opensearch.getServerlessAccessPolicy({
     *     name: exampleAwsOpensearchserverlessAccessPolicy.name,
     *     type: exampleAwsOpensearchserverlessAccessPolicy.type,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.opensearch.get_serverless_access_policy(name=example_aws_opensearchserverless_access_policy["name"],
     *     type=example_aws_opensearchserverless_access_policy["type"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.OpenSearch.GetServerlessAccessPolicy.Invoke(new()
     *     {
     *         Name = exampleAwsOpensearchserverlessAccessPolicy.Name,
     *         Type = exampleAwsOpensearchserverlessAccessPolicy.Type,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := opensearch.LookupServerlessAccessPolicy(ctx, &opensearch.LookupServerlessAccessPolicyArgs{
     * 			Name: exampleAwsOpensearchserverlessAccessPolicy.Name,
     * 			Type: exampleAwsOpensearchserverlessAccessPolicy.Type,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.opensearch.OpensearchFunctions;
     * import com.pulumi.aws.opensearch.inputs.GetServerlessAccessPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OpensearchFunctions.getServerlessAccessPolicy(GetServerlessAccessPolicyArgs.builder()
     *             .name(exampleAwsOpensearchserverlessAccessPolicy.name())
     *             .type(exampleAwsOpensearchserverlessAccessPolicy.type())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:opensearch:getServerlessAccessPolicy
     *       Arguments:
     *         name: ${exampleAwsOpensearchserverlessAccessPolicy.name}
     *         type: ${exampleAwsOpensearchserverlessAccessPolicy.type}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerlessAccessPolicy.
     * @return A collection of values returned by getServerlessAccessPolicy.
     */
    public suspend fun getServerlessAccessPolicy(argument: GetServerlessAccessPolicyPlainArgs): GetServerlessAccessPolicyResult =
        getServerlessAccessPolicyResultToKotlin(getServerlessAccessPolicyPlain(argument.toJava()).await())

    /**
     * @see [getServerlessAccessPolicy].
     * @param name Name of the policy.
     * @param type Type of access policy. Must be `data`.
     * @return A collection of values returned by getServerlessAccessPolicy.
     */
    public suspend fun getServerlessAccessPolicy(name: String, type: String): GetServerlessAccessPolicyResult {
        val argument = GetServerlessAccessPolicyPlainArgs(
            name = name,
            type = type,
        )
        return getServerlessAccessPolicyResultToKotlin(getServerlessAccessPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerlessAccessPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;opensearch&#46;kotlin&#46;inputs&#46;GetServerlessAccessPolicyPlainArgs].
     * @return A collection of values returned by getServerlessAccessPolicy.
     */
    public suspend fun getServerlessAccessPolicy(argument: suspend GetServerlessAccessPolicyPlainArgsBuilder.() -> Unit): GetServerlessAccessPolicyResult {
        val builder = GetServerlessAccessPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerlessAccessPolicyResultToKotlin(getServerlessAccessPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS OpenSearch Serverless Collection.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.opensearch.getServerlessCollection({
     *     name: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.opensearch.get_serverless_collection(name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.OpenSearch.GetServerlessCollection.Invoke(new()
     *     {
     *         Name = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := opensearch.LookupServerlessCollection(ctx, &opensearch.LookupServerlessCollectionArgs{
     * 			Name: pulumi.StringRef("example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.opensearch.OpensearchFunctions;
     * import com.pulumi.aws.opensearch.inputs.GetServerlessCollectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OpensearchFunctions.getServerlessCollection(GetServerlessCollectionArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:opensearch:getServerlessCollection
     *       Arguments:
     *         name: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerlessCollection.
     * @return A collection of values returned by getServerlessCollection.
     */
    public suspend fun getServerlessCollection(argument: GetServerlessCollectionPlainArgs): GetServerlessCollectionResult =
        getServerlessCollectionResultToKotlin(getServerlessCollectionPlain(argument.toJava()).await())

    /**
     * @see [getServerlessCollection].
     * @param id ID of the collection. Either `id` or `name` must be provided.
     * @param name Name of the collection. Either `name` or `id` must be provided.
     * @return A collection of values returned by getServerlessCollection.
     */
    public suspend fun getServerlessCollection(id: String? = null, name: String? = null): GetServerlessCollectionResult {
        val argument = GetServerlessCollectionPlainArgs(
            id = id,
            name = name,
        )
        return getServerlessCollectionResultToKotlin(getServerlessCollectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerlessCollection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;opensearch&#46;kotlin&#46;inputs&#46;GetServerlessCollectionPlainArgs].
     * @return A collection of values returned by getServerlessCollection.
     */
    public suspend fun getServerlessCollection(argument: suspend GetServerlessCollectionPlainArgsBuilder.() -> Unit): GetServerlessCollectionResult {
        val builder = GetServerlessCollectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerlessCollectionResultToKotlin(getServerlessCollectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS OpenSearch Serverless Lifecycle Policy.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.opensearch.getServerlessLifecyclePolicy({
     *     name: "example-lifecycle-policy",
     *     type: "retention",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.opensearch.get_serverless_lifecycle_policy(name="example-lifecycle-policy",
     *     type="retention")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.OpenSearch.GetServerlessLifecyclePolicy.Invoke(new()
     *     {
     *         Name = "example-lifecycle-policy",
     *         Type = "retention",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := opensearch.LookupServerlessLifecyclePolicy(ctx, &opensearch.LookupServerlessLifecyclePolicyArgs{
     * 			Name: "example-lifecycle-policy",
     * 			Type: "retention",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.opensearch.OpensearchFunctions;
     * import com.pulumi.aws.opensearch.inputs.GetServerlessLifecyclePolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OpensearchFunctions.getServerlessLifecyclePolicy(GetServerlessLifecyclePolicyArgs.builder()
     *             .name("example-lifecycle-policy")
     *             .type("retention")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:opensearch:getServerlessLifecyclePolicy
     *       Arguments:
     *         name: example-lifecycle-policy
     *         type: retention
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerlessLifecyclePolicy.
     * @return A collection of values returned by getServerlessLifecyclePolicy.
     */
    public suspend fun getServerlessLifecyclePolicy(argument: GetServerlessLifecyclePolicyPlainArgs): GetServerlessLifecyclePolicyResult =
        getServerlessLifecyclePolicyResultToKotlin(getServerlessLifecyclePolicyPlain(argument.toJava()).await())

    /**
     * @see [getServerlessLifecyclePolicy].
     * @param name Name of the policy
     * @param type Type of lifecycle policy. Must be `retention`.
     * @return A collection of values returned by getServerlessLifecyclePolicy.
     */
    public suspend fun getServerlessLifecyclePolicy(name: String, type: String): GetServerlessLifecyclePolicyResult {
        val argument = GetServerlessLifecyclePolicyPlainArgs(
            name = name,
            type = type,
        )
        return getServerlessLifecyclePolicyResultToKotlin(getServerlessLifecyclePolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerlessLifecyclePolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;opensearch&#46;kotlin&#46;inputs&#46;GetServerlessLifecyclePolicyPlainArgs].
     * @return A collection of values returned by getServerlessLifecyclePolicy.
     */
    public suspend fun getServerlessLifecyclePolicy(argument: suspend GetServerlessLifecyclePolicyPlainArgsBuilder.() -> Unit): GetServerlessLifecyclePolicyResult {
        val builder = GetServerlessLifecyclePolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerlessLifecyclePolicyResultToKotlin(getServerlessLifecyclePolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS OpenSearch Serverless Security Config.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.opensearch.getServerlessSecurityConfig({
     *     id: "saml/12345678912/example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.opensearch.get_serverless_security_config(id="saml/12345678912/example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.OpenSearch.GetServerlessSecurityConfig.Invoke(new()
     *     {
     *         Id = "saml/12345678912/example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := opensearch.LookupServerlessSecurityConfig(ctx, &opensearch.LookupServerlessSecurityConfigArgs{
     * 			Id: "saml/12345678912/example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.opensearch.OpensearchFunctions;
     * import com.pulumi.aws.opensearch.inputs.GetServerlessSecurityConfigArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OpensearchFunctions.getServerlessSecurityConfig(GetServerlessSecurityConfigArgs.builder()
     *             .id("saml/12345678912/example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:opensearch:getServerlessSecurityConfig
     *       Arguments:
     *         id: saml/12345678912/example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerlessSecurityConfig.
     * @return A collection of values returned by getServerlessSecurityConfig.
     */
    public suspend fun getServerlessSecurityConfig(argument: GetServerlessSecurityConfigPlainArgs): GetServerlessSecurityConfigResult =
        getServerlessSecurityConfigResultToKotlin(getServerlessSecurityConfigPlain(argument.toJava()).await())

    /**
     * @see [getServerlessSecurityConfig].
     * @param id The unique identifier of the security configuration.
     * @param samlOptions SAML options for the security configuration.
     * @return A collection of values returned by getServerlessSecurityConfig.
     */
    public suspend fun getServerlessSecurityConfig(
        id: String,
        samlOptions: GetServerlessSecurityConfigSamlOptions? = null,
    ): GetServerlessSecurityConfigResult {
        val argument = GetServerlessSecurityConfigPlainArgs(
            id = id,
            samlOptions = samlOptions,
        )
        return getServerlessSecurityConfigResultToKotlin(getServerlessSecurityConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerlessSecurityConfig].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;opensearch&#46;kotlin&#46;inputs&#46;GetServerlessSecurityConfigPlainArgs].
     * @return A collection of values returned by getServerlessSecurityConfig.
     */
    public suspend fun getServerlessSecurityConfig(argument: suspend GetServerlessSecurityConfigPlainArgsBuilder.() -> Unit): GetServerlessSecurityConfigResult {
        val builder = GetServerlessSecurityConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerlessSecurityConfigResultToKotlin(getServerlessSecurityConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an AWS OpenSearch Serverless Security Policy.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.opensearch.getServerlessSecurityPolicy({
     *     name: "example-security-policy",
     *     type: "encryption",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.opensearch.get_serverless_security_policy(name="example-security-policy",
     *     type="encryption")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.OpenSearch.GetServerlessSecurityPolicy.Invoke(new()
     *     {
     *         Name = "example-security-policy",
     *         Type = "encryption",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := opensearch.LookupServerlessSecurityPolicy(ctx, &opensearch.LookupServerlessSecurityPolicyArgs{
     * 			Name: "example-security-policy",
     * 			Type: "encryption",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.opensearch.OpensearchFunctions;
     * import com.pulumi.aws.opensearch.inputs.GetServerlessSecurityPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OpensearchFunctions.getServerlessSecurityPolicy(GetServerlessSecurityPolicyArgs.builder()
     *             .name("example-security-policy")
     *             .type("encryption")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:opensearch:getServerlessSecurityPolicy
     *       Arguments:
     *         name: example-security-policy
     *         type: encryption
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerlessSecurityPolicy.
     * @return A collection of values returned by getServerlessSecurityPolicy.
     */
    public suspend fun getServerlessSecurityPolicy(argument: GetServerlessSecurityPolicyPlainArgs): GetServerlessSecurityPolicyResult =
        getServerlessSecurityPolicyResultToKotlin(getServerlessSecurityPolicyPlain(argument.toJava()).await())

    /**
     * @see [getServerlessSecurityPolicy].
     * @param name Name of the policy
     * @param type Type of security policy. One of `encryption` or `network`.
     * @return A collection of values returned by getServerlessSecurityPolicy.
     */
    public suspend fun getServerlessSecurityPolicy(name: String, type: String): GetServerlessSecurityPolicyResult {
        val argument = GetServerlessSecurityPolicyPlainArgs(
            name = name,
            type = type,
        )
        return getServerlessSecurityPolicyResultToKotlin(getServerlessSecurityPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerlessSecurityPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;opensearch&#46;kotlin&#46;inputs&#46;GetServerlessSecurityPolicyPlainArgs].
     * @return A collection of values returned by getServerlessSecurityPolicy.
     */
    public suspend fun getServerlessSecurityPolicy(argument: suspend GetServerlessSecurityPolicyPlainArgsBuilder.() -> Unit): GetServerlessSecurityPolicyResult {
        val builder = GetServerlessSecurityPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerlessSecurityPolicyResultToKotlin(getServerlessSecurityPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS OpenSearch Serverless VPC Endpoint.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.opensearch.getServerlessVpcEndpoint({
     *     vpcEndpointId: "vpce-829a4487959e2a839",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.opensearch.get_serverless_vpc_endpoint(vpc_endpoint_id="vpce-829a4487959e2a839")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.OpenSearch.GetServerlessVpcEndpoint.Invoke(new()
     *     {
     *         VpcEndpointId = "vpce-829a4487959e2a839",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := opensearch.LookupServerlessVpcEndpoint(ctx, &opensearch.LookupServerlessVpcEndpointArgs{
     * 			VpcEndpointId: "vpce-829a4487959e2a839",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.opensearch.OpensearchFunctions;
     * import com.pulumi.aws.opensearch.inputs.GetServerlessVpcEndpointArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OpensearchFunctions.getServerlessVpcEndpoint(GetServerlessVpcEndpointArgs.builder()
     *             .vpcEndpointId("vpce-829a4487959e2a839")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:opensearch:getServerlessVpcEndpoint
     *       Arguments:
     *         vpcEndpointId: vpce-829a4487959e2a839
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerlessVpcEndpoint.
     * @return A collection of values returned by getServerlessVpcEndpoint.
     */
    public suspend fun getServerlessVpcEndpoint(argument: GetServerlessVpcEndpointPlainArgs): GetServerlessVpcEndpointResult =
        getServerlessVpcEndpointResultToKotlin(getServerlessVpcEndpointPlain(argument.toJava()).await())

    /**
     * @see [getServerlessVpcEndpoint].
     * @param vpcEndpointId The unique identifier of the endpoint.
     * @return A collection of values returned by getServerlessVpcEndpoint.
     */
    public suspend fun getServerlessVpcEndpoint(vpcEndpointId: String): GetServerlessVpcEndpointResult {
        val argument = GetServerlessVpcEndpointPlainArgs(
            vpcEndpointId = vpcEndpointId,
        )
        return getServerlessVpcEndpointResultToKotlin(getServerlessVpcEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerlessVpcEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;opensearch&#46;kotlin&#46;inputs&#46;GetServerlessVpcEndpointPlainArgs].
     * @return A collection of values returned by getServerlessVpcEndpoint.
     */
    public suspend fun getServerlessVpcEndpoint(argument: suspend GetServerlessVpcEndpointPlainArgsBuilder.() -> Unit): GetServerlessVpcEndpointResult {
        val builder = GetServerlessVpcEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerlessVpcEndpointResultToKotlin(getServerlessVpcEndpointPlain(builtArgument.toJava()).await())
    }
}
