@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionConnectionProperties
import com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionLocalDomainInfo
import com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionRemoteDomainInfo
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionConnectionProperties.Companion.toKotlin as outboundConnectionConnectionPropertiesToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionLocalDomainInfo.Companion.toKotlin as outboundConnectionLocalDomainInfoToKotlin
import com.pulumi.aws.opensearch.kotlin.outputs.OutboundConnectionRemoteDomainInfo.Companion.toKotlin as outboundConnectionRemoteDomainInfoToKotlin

/**
 * Builder for [OutboundConnection].
 */
@PulumiTagMarker
public class OutboundConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OutboundConnectionArgs = OutboundConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OutboundConnectionArgsBuilder.() -> Unit) {
        val builder = OutboundConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OutboundConnection {
        val builtJavaResource = com.pulumi.aws.opensearch.OutboundConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OutboundConnection(builtJavaResource)
    }
}

/**
 * Manages an AWS Opensearch Outbound Connection.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const currentGetRegion = aws.getRegion({});
 * const foo = new aws.opensearch.OutboundConnection("foo", {
 *     connectionAlias: "outbound_connection",
 *     connectionMode: "DIRECT",
 *     localDomainInfo: {
 *         ownerId: current.then(current => current.accountId),
 *         region: currentGetRegion.then(currentGetRegion => currentGetRegion.name),
 *         domainName: localDomain.domainName,
 *     },
 *     remoteDomainInfo: {
 *         ownerId: current.then(current => current.accountId),
 *         region: currentGetRegion.then(currentGetRegion => currentGetRegion.name),
 *         domainName: remoteDomain.domainName,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * current_get_region = aws.get_region()
 * foo = aws.opensearch.OutboundConnection("foo",
 *     connection_alias="outbound_connection",
 *     connection_mode="DIRECT",
 *     local_domain_info={
 *         "owner_id": current.account_id,
 *         "region": current_get_region.name,
 *         "domain_name": local_domain["domainName"],
 *     },
 *     remote_domain_info={
 *         "owner_id": current.account_id,
 *         "region": current_get_region.name,
 *         "domain_name": remote_domain["domainName"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var currentGetRegion = Aws.GetRegion.Invoke();
 *     var foo = new Aws.OpenSearch.OutboundConnection("foo", new()
 *     {
 *         ConnectionAlias = "outbound_connection",
 *         ConnectionMode = "DIRECT",
 *         LocalDomainInfo = new Aws.OpenSearch.Inputs.OutboundConnectionLocalDomainInfoArgs
 *         {
 *             OwnerId = current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *             Region = currentGetRegion.Apply(getRegionResult => getRegionResult.Name),
 *             DomainName = localDomain.DomainName,
 *         },
 *         RemoteDomainInfo = new Aws.OpenSearch.Inputs.OutboundConnectionRemoteDomainInfoArgs
 *         {
 *             OwnerId = current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *             Region = currentGetRegion.Apply(getRegionResult => getRegionResult.Name),
 *             DomainName = remoteDomain.DomainName,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		currentGetRegion, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = opensearch.NewOutboundConnection(ctx, "foo", &opensearch.OutboundConnectionArgs{
 * 			ConnectionAlias: pulumi.String("outbound_connection"),
 * 			ConnectionMode:  pulumi.String("DIRECT"),
 * 			LocalDomainInfo: &opensearch.OutboundConnectionLocalDomainInfoArgs{
 * 				OwnerId:    pulumi.String(current.AccountId),
 * 				Region:     pulumi.String(currentGetRegion.Name),
 * 				DomainName: pulumi.Any(localDomain.DomainName),
 * 			},
 * 			RemoteDomainInfo: &opensearch.OutboundConnectionRemoteDomainInfoArgs{
 * 				OwnerId:    pulumi.String(current.AccountId),
 * 				Region:     pulumi.String(currentGetRegion.Name),
 * 				DomainName: pulumi.Any(remoteDomain.DomainName),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.opensearch.OutboundConnection;
 * import com.pulumi.aws.opensearch.OutboundConnectionArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionLocalDomainInfoArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionRemoteDomainInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var currentGetRegion = AwsFunctions.getRegion();
 *         var foo = new OutboundConnection("foo", OutboundConnectionArgs.builder()
 *             .connectionAlias("outbound_connection")
 *             .connectionMode("DIRECT")
 *             .localDomainInfo(OutboundConnectionLocalDomainInfoArgs.builder()
 *                 .ownerId(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                 .region(currentGetRegion.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .domainName(localDomain.domainName())
 *                 .build())
 *             .remoteDomainInfo(OutboundConnectionRemoteDomainInfoArgs.builder()
 *                 .ownerId(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                 .region(currentGetRegion.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .domainName(remoteDomain.domainName())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:opensearch:OutboundConnection
 *     properties:
 *       connectionAlias: outbound_connection
 *       connectionMode: DIRECT
 *       localDomainInfo:
 *         ownerId: ${current.accountId}
 *         region: ${currentGetRegion.name}
 *         domainName: ${localDomain.domainName}
 *       remoteDomainInfo:
 *         ownerId: ${current.accountId}
 *         region: ${currentGetRegion.name}
 *         domainName: ${remoteDomain.domainName}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   currentGetRegion:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Opensearch Outbound Connections using the Outbound Connection ID. For example:
 * ```sh
 * $ pulumi import aws:opensearch/outboundConnection:OutboundConnection foo connection-id
 * ```
 */
public class OutboundConnection internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.OutboundConnection,
) : KotlinCustomResource(javaResource, OutboundConnectionMapper) {
    /**
     * Accepts the connection.
     */
    public val acceptConnection: Output<Boolean>?
        get() = javaResource.acceptConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the connection alias that will be used by the customer for this connection.
     */
    public val connectionAlias: Output<String>
        get() = javaResource.connectionAlias().applyValue({ args0 -> args0 })

    /**
     * Specifies the connection mode. Accepted values are `DIRECT` or `VPC_ENDPOINT`.
     */
    public val connectionMode: Output<String>?
        get() = javaResource.connectionMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for the outbound connection.
     */
    public val connectionProperties: Output<OutboundConnectionConnectionProperties>
        get() = javaResource.connectionProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                outboundConnectionConnectionPropertiesToKotlin(args0)
            })
        })

    /**
     * Status of the connection request.
     */
    public val connectionStatus: Output<String>
        get() = javaResource.connectionStatus().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the local Opensearch domain.
     */
    public val localDomainInfo: Output<OutboundConnectionLocalDomainInfo>
        get() = javaResource.localDomainInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                outboundConnectionLocalDomainInfoToKotlin(args0)
            })
        })

    /**
     * Configuration block for the remote Opensearch domain.
     */
    public val remoteDomainInfo: Output<OutboundConnectionRemoteDomainInfo>
        get() = javaResource.remoteDomainInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                outboundConnectionRemoteDomainInfoToKotlin(args0)
            })
        })
}

public object OutboundConnectionMapper : ResourceMapper<OutboundConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.OutboundConnection::class == javaResource::class

    override fun map(javaResource: Resource): OutboundConnection = OutboundConnection(
        javaResource as
            com.pulumi.aws.opensearch.OutboundConnection,
    )
}

/**
 * @see [OutboundConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OutboundConnection].
 */
public suspend fun outboundConnection(
    name: String,
    block: suspend OutboundConnectionResourceBuilder.() -> Unit,
): OutboundConnection {
    val builder = OutboundConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OutboundConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun outboundConnection(name: String): OutboundConnection {
    val builder = OutboundConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
