@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.kotlin.outputs.PackagePackageSource
import com.pulumi.aws.opensearch.kotlin.outputs.PackagePackageSource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Package].
 */
@PulumiTagMarker
public class PackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PackageArgs = PackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PackageArgsBuilder.() -> Unit) {
        val builder = PackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Package {
        val builtJavaResource = com.pulumi.aws.opensearch.Package(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Package(builtJavaResource)
    }
}

/**
 * Manages an AWS Opensearch Package.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const myOpensearchPackages = new aws.s3.BucketV2("my_opensearch_packages", {bucket: "my-opensearch-packages"});
 * const example = new aws.s3.BucketObjectv2("example", {
 *     bucket: myOpensearchPackages.bucket,
 *     key: "example.txt",
 *     source: new pulumi.asset.FileAsset("./example.txt"),
 *     etag: std.filemd5({
 *         input: "./example.txt",
 *     }).then(invoke => invoke.result),
 * });
 * const examplePackage = new aws.opensearch.Package("example", {
 *     packageName: "example-txt",
 *     packageSource: {
 *         s3BucketName: myOpensearchPackages.bucket,
 *         s3Key: example.key,
 *     },
 *     packageType: "TXT-DICTIONARY",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * my_opensearch_packages = aws.s3.BucketV2("my_opensearch_packages", bucket="my-opensearch-packages")
 * example = aws.s3.BucketObjectv2("example",
 *     bucket=my_opensearch_packages.bucket,
 *     key="example.txt",
 *     source=pulumi.FileAsset("./example.txt"),
 *     etag=std.filemd5(input="./example.txt").result)
 * example_package = aws.opensearch.Package("example",
 *     package_name="example-txt",
 *     package_source={
 *         "s3_bucket_name": my_opensearch_packages.bucket,
 *         "s3_key": example.key,
 *     },
 *     package_type="TXT-DICTIONARY")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myOpensearchPackages = new Aws.S3.BucketV2("my_opensearch_packages", new()
 *     {
 *         Bucket = "my-opensearch-packages",
 *     });
 *     var example = new Aws.S3.BucketObjectv2("example", new()
 *     {
 *         Bucket = myOpensearchPackages.Bucket,
 *         Key = "example.txt",
 *         Source = new FileAsset("./example.txt"),
 *         Etag = Std.Filemd5.Invoke(new()
 *         {
 *             Input = "./example.txt",
 *         }).Apply(invoke => invoke.Result),
 *     });
 *     var examplePackage = new Aws.OpenSearch.Package("example", new()
 *     {
 *         PackageName = "example-txt",
 *         PackageSource = new Aws.OpenSearch.Inputs.PackagePackageSourceArgs
 *         {
 *             S3BucketName = myOpensearchPackages.Bucket,
 *             S3Key = example.Key,
 *         },
 *         PackageType = "TXT-DICTIONARY",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		myOpensearchPackages, err := s3.NewBucketV2(ctx, "my_opensearch_packages", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-opensearch-packages"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFilemd5, err := std.Filemd5(ctx, &std.Filemd5Args{
 * 			Input: "./example.txt",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := s3.NewBucketObjectv2(ctx, "example", &s3.BucketObjectv2Args{
 * 			Bucket: myOpensearchPackages.Bucket,
 * 			Key:    pulumi.String("example.txt"),
 * 			Source: pulumi.NewFileAsset("./example.txt"),
 * 			Etag:   pulumi.String(invokeFilemd5.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = opensearch.NewPackage(ctx, "example", &opensearch.PackageArgs{
 * 			PackageName: pulumi.String("example-txt"),
 * 			PackageSource: &opensearch.PackagePackageSourceArgs{
 * 				S3BucketName: myOpensearchPackages.Bucket,
 * 				S3Key:        example.Key,
 * 			},
 * 			PackageType: pulumi.String("TXT-DICTIONARY"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.opensearch.Package;
 * import com.pulumi.aws.opensearch.PackageArgs;
 * import com.pulumi.aws.opensearch.inputs.PackagePackageSourceArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myOpensearchPackages = new BucketV2("myOpensearchPackages", BucketV2Args.builder()
 *             .bucket("my-opensearch-packages")
 *             .build());
 *         var example = new BucketObjectv2("example", BucketObjectv2Args.builder()
 *             .bucket(myOpensearchPackages.bucket())
 *             .key("example.txt")
 *             .source(new FileAsset("./example.txt"))
 *             .etag(StdFunctions.filemd5(Filemd5Args.builder()
 *                 .input("./example.txt")
 *                 .build()).result())
 *             .build());
 *         var examplePackage = new Package("examplePackage", PackageArgs.builder()
 *             .packageName("example-txt")
 *             .packageSource(PackagePackageSourceArgs.builder()
 *                 .s3BucketName(myOpensearchPackages.bucket())
 *                 .s3Key(example.key())
 *                 .build())
 *             .packageType("TXT-DICTIONARY")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myOpensearchPackages:
 *     type: aws:s3:BucketV2
 *     name: my_opensearch_packages
 *     properties:
 *       bucket: my-opensearch-packages
 *   example:
 *     type: aws:s3:BucketObjectv2
 *     properties:
 *       bucket: ${myOpensearchPackages.bucket}
 *       key: example.txt
 *       source:
 *         fn::FileAsset: ./example.txt
 *       etag:
 *         fn::invoke:
 *           Function: std:filemd5
 *           Arguments:
 *             input: ./example.txt
 *           Return: result
 *   examplePackage:
 *     type: aws:opensearch:Package
 *     name: example
 *     properties:
 *       packageName: example-txt
 *       packageSource:
 *         s3BucketName: ${myOpensearchPackages.bucket}
 *         s3Key: ${example.key}
 *       packageType: TXT-DICTIONARY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Opensearch Packages using the Package ID. For example:
 * ```sh
 * $ pulumi import aws:opensearch/package:Package example package-id
 * ```
 */
public class Package internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.Package,
) : KotlinCustomResource(javaResource, PackageMapper) {
    /**
     * The current version of the package.
     */
    public val availablePackageVersion: Output<String>
        get() = javaResource.availablePackageVersion().applyValue({ args0 -> args0 })

    /**
     * Description of the package.
     */
    public val packageDescription: Output<String>?
        get() = javaResource.packageDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val packageId: Output<String>
        get() = javaResource.packageId().applyValue({ args0 -> args0 })

    /**
     * Unique name for the package.
     */
    public val packageName: Output<String>
        get() = javaResource.packageName().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the package source options.
     */
    public val packageSource: Output<PackagePackageSource>
        get() = javaResource.packageSource().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The type of package.
     */
    public val packageType: Output<String>
        get() = javaResource.packageType().applyValue({ args0 -> args0 })
}

public object PackageMapper : ResourceMapper<Package> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.Package::class == javaResource::class

    override fun map(javaResource: Resource): Package = Package(
        javaResource as
            com.pulumi.aws.opensearch.Package,
    )
}

/**
 * @see [Package].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Package].
 */
public suspend fun `package`(name: String, block: suspend PackageResourceBuilder.() -> Unit): Package {
    val builder = PackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Package].
 * @param name The _unique_ name of the resulting resource.
 */
public fun `package`(name: String): Package {
    val builder = PackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
