@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.PackageArgs.builder
import com.pulumi.aws.opensearch.kotlin.inputs.PackagePackageSourceArgs
import com.pulumi.aws.opensearch.kotlin.inputs.PackagePackageSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages an AWS Opensearch Package.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const myOpensearchPackages = new aws.s3.BucketV2("my_opensearch_packages", {bucket: "my-opensearch-packages"});
 * const example = new aws.s3.BucketObjectv2("example", {
 *     bucket: myOpensearchPackages.bucket,
 *     key: "example.txt",
 *     source: new pulumi.asset.FileAsset("./example.txt"),
 *     etag: std.filemd5({
 *         input: "./example.txt",
 *     }).then(invoke => invoke.result),
 * });
 * const examplePackage = new aws.opensearch.Package("example", {
 *     packageName: "example-txt",
 *     packageSource: {
 *         s3BucketName: myOpensearchPackages.bucket,
 *         s3Key: example.key,
 *     },
 *     packageType: "TXT-DICTIONARY",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * my_opensearch_packages = aws.s3.BucketV2("my_opensearch_packages", bucket="my-opensearch-packages")
 * example = aws.s3.BucketObjectv2("example",
 *     bucket=my_opensearch_packages.bucket,
 *     key="example.txt",
 *     source=pulumi.FileAsset("./example.txt"),
 *     etag=std.filemd5(input="./example.txt").result)
 * example_package = aws.opensearch.Package("example",
 *     package_name="example-txt",
 *     package_source={
 *         "s3_bucket_name": my_opensearch_packages.bucket,
 *         "s3_key": example.key,
 *     },
 *     package_type="TXT-DICTIONARY")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myOpensearchPackages = new Aws.S3.BucketV2("my_opensearch_packages", new()
 *     {
 *         Bucket = "my-opensearch-packages",
 *     });
 *     var example = new Aws.S3.BucketObjectv2("example", new()
 *     {
 *         Bucket = myOpensearchPackages.Bucket,
 *         Key = "example.txt",
 *         Source = new FileAsset("./example.txt"),
 *         Etag = Std.Filemd5.Invoke(new()
 *         {
 *             Input = "./example.txt",
 *         }).Apply(invoke => invoke.Result),
 *     });
 *     var examplePackage = new Aws.OpenSearch.Package("example", new()
 *     {
 *         PackageName = "example-txt",
 *         PackageSource = new Aws.OpenSearch.Inputs.PackagePackageSourceArgs
 *         {
 *             S3BucketName = myOpensearchPackages.Bucket,
 *             S3Key = example.Key,
 *         },
 *         PackageType = "TXT-DICTIONARY",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		myOpensearchPackages, err := s3.NewBucketV2(ctx, "my_opensearch_packages", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-opensearch-packages"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFilemd5, err := std.Filemd5(ctx, &std.Filemd5Args{
 * 			Input: "./example.txt",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := s3.NewBucketObjectv2(ctx, "example", &s3.BucketObjectv2Args{
 * 			Bucket: myOpensearchPackages.Bucket,
 * 			Key:    pulumi.String("example.txt"),
 * 			Source: pulumi.NewFileAsset("./example.txt"),
 * 			Etag:   pulumi.String(invokeFilemd5.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = opensearch.NewPackage(ctx, "example", &opensearch.PackageArgs{
 * 			PackageName: pulumi.String("example-txt"),
 * 			PackageSource: &opensearch.PackagePackageSourceArgs{
 * 				S3BucketName: myOpensearchPackages.Bucket,
 * 				S3Key:        example.Key,
 * 			},
 * 			PackageType: pulumi.String("TXT-DICTIONARY"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.opensearch.Package;
 * import com.pulumi.aws.opensearch.PackageArgs;
 * import com.pulumi.aws.opensearch.inputs.PackagePackageSourceArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myOpensearchPackages = new BucketV2("myOpensearchPackages", BucketV2Args.builder()
 *             .bucket("my-opensearch-packages")
 *             .build());
 *         var example = new BucketObjectv2("example", BucketObjectv2Args.builder()
 *             .bucket(myOpensearchPackages.bucket())
 *             .key("example.txt")
 *             .source(new FileAsset("./example.txt"))
 *             .etag(StdFunctions.filemd5(Filemd5Args.builder()
 *                 .input("./example.txt")
 *                 .build()).result())
 *             .build());
 *         var examplePackage = new Package("examplePackage", PackageArgs.builder()
 *             .packageName("example-txt")
 *             .packageSource(PackagePackageSourceArgs.builder()
 *                 .s3BucketName(myOpensearchPackages.bucket())
 *                 .s3Key(example.key())
 *                 .build())
 *             .packageType("TXT-DICTIONARY")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myOpensearchPackages:
 *     type: aws:s3:BucketV2
 *     name: my_opensearch_packages
 *     properties:
 *       bucket: my-opensearch-packages
 *   example:
 *     type: aws:s3:BucketObjectv2
 *     properties:
 *       bucket: ${myOpensearchPackages.bucket}
 *       key: example.txt
 *       source:
 *         fn::FileAsset: ./example.txt
 *       etag:
 *         fn::invoke:
 *           Function: std:filemd5
 *           Arguments:
 *             input: ./example.txt
 *           Return: result
 *   examplePackage:
 *     type: aws:opensearch:Package
 *     name: example
 *     properties:
 *       packageName: example-txt
 *       packageSource:
 *         s3BucketName: ${myOpensearchPackages.bucket}
 *         s3Key: ${example.key}
 *       packageType: TXT-DICTIONARY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS Opensearch Packages using the Package ID. For example:
 * ```sh
 * $ pulumi import aws:opensearch/package:Package example package-id
 * ```
 * @property packageDescription Description of the package.
 * @property packageName Unique name for the package.
 * @property packageSource Configuration block for the package source options.
 * @property packageType The type of package.
 */
public data class PackageArgs(
    public val packageDescription: Output<String>? = null,
    public val packageName: Output<String>? = null,
    public val packageSource: Output<PackagePackageSourceArgs>? = null,
    public val packageType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.PackageArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.PackageArgs =
        com.pulumi.aws.opensearch.PackageArgs.builder()
            .packageDescription(packageDescription?.applyValue({ args0 -> args0 }))
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .packageSource(packageSource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .packageType(packageType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PackageArgs].
 */
@PulumiTagMarker
public class PackageArgsBuilder internal constructor() {
    private var packageDescription: Output<String>? = null

    private var packageName: Output<String>? = null

    private var packageSource: Output<PackagePackageSourceArgs>? = null

    private var packageType: Output<String>? = null

    /**
     * @param value Description of the package.
     */
    @JvmName("srdfvvjrwcqeeoff")
    public suspend fun packageDescription(`value`: Output<String>) {
        this.packageDescription = value
    }

    /**
     * @param value Unique name for the package.
     */
    @JvmName("ougnisdcocbawlxx")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value Configuration block for the package source options.
     */
    @JvmName("qdijaoirctjpatpc")
    public suspend fun packageSource(`value`: Output<PackagePackageSourceArgs>) {
        this.packageSource = value
    }

    /**
     * @param value The type of package.
     */
    @JvmName("esyogncdohqvmpcf")
    public suspend fun packageType(`value`: Output<String>) {
        this.packageType = value
    }

    /**
     * @param value Description of the package.
     */
    @JvmName("rgljbpqmatraeujf")
    public suspend fun packageDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageDescription = mapped
    }

    /**
     * @param value Unique name for the package.
     */
    @JvmName("metdikjjcexodvpb")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value Configuration block for the package source options.
     */
    @JvmName("qcuungsglulstbnf")
    public suspend fun packageSource(`value`: PackagePackageSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageSource = mapped
    }

    /**
     * @param argument Configuration block for the package source options.
     */
    @JvmName("ajipcqniwgiwpfry")
    public suspend fun packageSource(argument: suspend PackagePackageSourceArgsBuilder.() -> Unit) {
        val toBeMapped = PackagePackageSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.packageSource = mapped
    }

    /**
     * @param value The type of package.
     */
    @JvmName("xxwfepoyqqmaflkt")
    public suspend fun packageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageType = mapped
    }

    internal fun build(): PackageArgs = PackageArgs(
        packageDescription = packageDescription,
        packageName = packageName,
        packageSource = packageSource,
        packageType = packageType,
    )
}
