@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PackageAssociation].
 */
@PulumiTagMarker
public class PackageAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PackageAssociationArgs = PackageAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PackageAssociationArgsBuilder.() -> Unit) {
        val builder = PackageAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PackageAssociation {
        val builtJavaResource = com.pulumi.aws.opensearch.PackageAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PackageAssociation(builtJavaResource)
    }
}

/**
 * Manages an AWS Opensearch Package Association.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myDomain = new aws.opensearch.Domain("my_domain", {
 *     domainName: "my-opensearch-domain",
 *     engineVersion: "Elasticsearch_7.10",
 *     clusterConfig: {
 *         instanceType: "r4.large.search",
 *     },
 * });
 * const example = new aws.opensearch.Package("example", {
 *     packageName: "example-txt",
 *     packageSource: {
 *         s3BucketName: myOpensearchPackages.bucket,
 *         s3Key: exampleAwsS3Object.key,
 *     },
 *     packageType: "TXT-DICTIONARY",
 * });
 * const examplePackageAssociation = new aws.opensearch.PackageAssociation("example", {
 *     packageId: example.id,
 *     domainName: myDomain.domainName,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_domain = aws.opensearch.Domain("my_domain",
 *     domain_name="my-opensearch-domain",
 *     engine_version="Elasticsearch_7.10",
 *     cluster_config={
 *         "instance_type": "r4.large.search",
 *     })
 * example = aws.opensearch.Package("example",
 *     package_name="example-txt",
 *     package_source={
 *         "s3_bucket_name": my_opensearch_packages["bucket"],
 *         "s3_key": example_aws_s3_object["key"],
 *     },
 *     package_type="TXT-DICTIONARY")
 * example_package_association = aws.opensearch.PackageAssociation("example",
 *     package_id=example.id,
 *     domain_name=my_domain.domain_name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myDomain = new Aws.OpenSearch.Domain("my_domain", new()
 *     {
 *         DomainName = "my-opensearch-domain",
 *         EngineVersion = "Elasticsearch_7.10",
 *         ClusterConfig = new Aws.OpenSearch.Inputs.DomainClusterConfigArgs
 *         {
 *             InstanceType = "r4.large.search",
 *         },
 *     });
 *     var example = new Aws.OpenSearch.Package("example", new()
 *     {
 *         PackageName = "example-txt",
 *         PackageSource = new Aws.OpenSearch.Inputs.PackagePackageSourceArgs
 *         {
 *             S3BucketName = myOpensearchPackages.Bucket,
 *             S3Key = exampleAwsS3Object.Key,
 *         },
 *         PackageType = "TXT-DICTIONARY",
 *     });
 *     var examplePackageAssociation = new Aws.OpenSearch.PackageAssociation("example", new()
 *     {
 *         PackageId = example.Id,
 *         DomainName = myDomain.DomainName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		myDomain, err := opensearch.NewDomain(ctx, "my_domain", &opensearch.DomainArgs{
 * 			DomainName:    pulumi.String("my-opensearch-domain"),
 * 			EngineVersion: pulumi.String("Elasticsearch_7.10"),
 * 			ClusterConfig: &opensearch.DomainClusterConfigArgs{
 * 				InstanceType: pulumi.String("r4.large.search"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := opensearch.NewPackage(ctx, "example", &opensearch.PackageArgs{
 * 			PackageName: pulumi.String("example-txt"),
 * 			PackageSource: &opensearch.PackagePackageSourceArgs{
 * 				S3BucketName: pulumi.Any(myOpensearchPackages.Bucket),
 * 				S3Key:        pulumi.Any(exampleAwsS3Object.Key),
 * 			},
 * 			PackageType: pulumi.String("TXT-DICTIONARY"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = opensearch.NewPackageAssociation(ctx, "example", &opensearch.PackageAssociationArgs{
 * 			PackageId:  example.ID(),
 * 			DomainName: myDomain.DomainName,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.opensearch.Package;
 * import com.pulumi.aws.opensearch.PackageArgs;
 * import com.pulumi.aws.opensearch.inputs.PackagePackageSourceArgs;
 * import com.pulumi.aws.opensearch.PackageAssociation;
 * import com.pulumi.aws.opensearch.PackageAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDomain = new Domain("myDomain", DomainArgs.builder()
 *             .domainName("my-opensearch-domain")
 *             .engineVersion("Elasticsearch_7.10")
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceType("r4.large.search")
 *                 .build())
 *             .build());
 *         var example = new Package("example", PackageArgs.builder()
 *             .packageName("example-txt")
 *             .packageSource(PackagePackageSourceArgs.builder()
 *                 .s3BucketName(myOpensearchPackages.bucket())
 *                 .s3Key(exampleAwsS3Object.key())
 *                 .build())
 *             .packageType("TXT-DICTIONARY")
 *             .build());
 *         var examplePackageAssociation = new PackageAssociation("examplePackageAssociation", PackageAssociationArgs.builder()
 *             .packageId(example.id())
 *             .domainName(myDomain.domainName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myDomain:
 *     type: aws:opensearch:Domain
 *     name: my_domain
 *     properties:
 *       domainName: my-opensearch-domain
 *       engineVersion: Elasticsearch_7.10
 *       clusterConfig:
 *         instanceType: r4.large.search
 *   example:
 *     type: aws:opensearch:Package
 *     properties:
 *       packageName: example-txt
 *       packageSource:
 *         s3BucketName: ${myOpensearchPackages.bucket}
 *         s3Key: ${exampleAwsS3Object.key}
 *       packageType: TXT-DICTIONARY
 *   examplePackageAssociation:
 *     type: aws:opensearch:PackageAssociation
 *     name: example
 *     properties:
 *       packageId: ${example.id}
 *       domainName: ${myDomain.domainName}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class PackageAssociation internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.PackageAssociation,
) : KotlinCustomResource(javaResource, PackageAssociationMapper) {
    /**
     * Name of the domain to associate the package with.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Internal ID of the package to associate with a domain.
     */
    public val packageId: Output<String>
        get() = javaResource.packageId().applyValue({ args0 -> args0 })

    public val referencePath: Output<String>
        get() = javaResource.referencePath().applyValue({ args0 -> args0 })
}

public object PackageAssociationMapper : ResourceMapper<PackageAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.PackageAssociation::class == javaResource::class

    override fun map(javaResource: Resource): PackageAssociation = PackageAssociation(
        javaResource as
            com.pulumi.aws.opensearch.PackageAssociation,
    )
}

/**
 * @see [PackageAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PackageAssociation].
 */
public suspend fun packageAssociation(
    name: String,
    block: suspend PackageAssociationResourceBuilder.() -> Unit,
): PackageAssociation {
    val builder = PackageAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PackageAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun packageAssociation(name: String): PackageAssociation {
    val builder = PackageAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
