@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerlessAccessPolicy].
 */
@PulumiTagMarker
public class ServerlessAccessPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerlessAccessPolicyArgs = ServerlessAccessPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerlessAccessPolicyArgsBuilder.() -> Unit) {
        val builder = ServerlessAccessPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerlessAccessPolicy {
        val builtJavaResource =
            com.pulumi.aws.opensearch.ServerlessAccessPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerlessAccessPolicy(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS OpenSearch Serverless Access Policy. See AWS documentation for [data access policies](https://docs&#46;aws&#46;amazon&#46;com/opensearch-service/latest/developerguide/serverless-data-access&#46;html) and [supported data access policy permissions](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html#serverless-data-supported-permissions).
 * ## Example Usage
 * ### Grant all collection and index permissions
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const example = new aws.opensearch.ServerlessAccessPolicy("example", {
 *     name: "example",
 *     type: "data",
 *     description: "read and write permissions",
 *     policy: JSON.stringify([{
 *         Rules: [
 *             {
 *                 ResourceType: "index",
 *                 Resource: ["index/example-collection/*"],
 *                 Permission: ["aoss:*"],
 *             },
 *             {
 *                 ResourceType: "collection",
 *                 Resource: ["collection/example-collection"],
 *                 Permission: ["aoss:*"],
 *             },
 *         ],
 *         Principal: [current&#46;then(current => current&#46;arn)],
 *     }]),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example = aws.opensearch.ServerlessAccessPolicy("example",
 *     name="example",
 *     type="data",
 *     description="read and write permissions",
 *     policy=json.dumps([{
 *         "Rules": [
 *             {
 *                 "ResourceType": "index",
 *                 "Resource": ["index/example-collection/*"],
 *                 "Permission": ["aoss:*"],
 *             },
 *             {
 *                 "ResourceType": "collection",
 *                 "Resource": ["collection/example-collection"],
 *                 "Permission": ["aoss:*"],
 *             },
 *         ],
 *         "Principal": [current&#46;arn],
 *     }]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var example = new Aws.OpenSearch.ServerlessAccessPolicy("example", new()
 *     {
 *         Name = "example",
 *         Type = "data",
 *         Description = "read and write permissions",
 *         Policy = JsonSerializer.Serialize(new[]
 *         {
 *             new Dictionary<string, object?>
 *             {
 *                 ["Rules"] = new[]
 *                 {
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["ResourceType"] = "index",
 *                         ["Resource"] = new[]
 *                         {
 *                             "index/example-collection/*",
 *                         },
 *                         ["Permission"] = new[]
 *                         {
 *                             "aoss:*",
 *                         },
 *                     },
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["ResourceType"] = "collection",
 *                         ["Resource"] = new[]
 *                         {
 *                             "collection/example-collection",
 *                         },
 *                         ["Permission"] = new[]
 *                         {
 *                             "aoss:*",
 *                         },
 *                     },
 *                 },
 *                 ["Principal"] = new[]
 *                 {
 *                     current.Apply(getCallerIdentityResult => getCallerIdentityResult.Arn),
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal([]map[string]interface{}{
 * 			map[string]interface{}{
 * 				"Rules": []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"ResourceType": "index",
 * 						"Resource": []string{
 * 							"index/example-collection/*",
 * 						},
 * 						"Permission": []string{
 * 							"aoss:*",
 * 						},
 * 					},
 * 					map[string]interface{}{
 * 						"ResourceType": "collection",
 * 						"Resource": []string{
 * 							"collection/example-collection",
 * 						},
 * 						"Permission": []string{
 * 							"aoss:*",
 * 						},
 * 					},
 * 				},
 * 				"Principal": []*string{
 * 					current.Arn,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = opensearch.NewServerlessAccessPolicy(ctx, "example", &opensearch.ServerlessAccessPolicyArgs{
 * 			Name:        pulumi.String("example"),
 * 			Type:        pulumi.String("data"),
 * 			Description: pulumi.String("read and write permissions"),
 * 			Policy:      pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicy;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new ServerlessAccessPolicy("example", ServerlessAccessPolicyArgs.builder()
 *             .name("example")
 *             .type("data")
 *             .description("read and write permissions")
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty("Rules", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "index"),
 *                             jsonProperty("Resource", jsonArray("index/example-collection/*")),
 *                             jsonProperty("Permission", jsonArray("aoss:*"))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "collection"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection")),
 *                             jsonProperty("Permission", jsonArray("aoss:*"))
 *                         )
 *                     )),
 *                     jsonProperty("Principal", jsonArray(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn())))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:opensearch:ServerlessAccessPolicy
 *     properties:
 *       name: example
 *       type: data
 *       description: read and write permissions
 *       policy:
 *         fn::toJSON:
 *           - Rules:
 *               - ResourceType: index
 *                 Resource:
 *                   - index/example-collection/*
 *                 Permission:
 *                   - aoss:*
 *               - ResourceType: collection
 *                 Resource:
 *                   - collection/example-collection
 *                 Permission:
 *                   - aoss:*
 *             Principal:
 *               - ${current.arn}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Grant read-only collection and index permissions
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const example = new aws.opensearch.ServerlessAccessPolicy("example", {
 *     name: "example",
 *     type: "data",
 *     description: "read-only permissions",
 *     policy: JSON.stringify([{
 *         Rules: [
 *             {
 *                 ResourceType: "index",
 *                 Resource: ["index/example-collection/*"],
 *                 Permission: [
 *                     "aoss:DescribeIndex",
 *                     "aoss:ReadDocument",
 *                 ],
 *             },
 *             {
 *                 ResourceType: "collection",
 *                 Resource: ["collection/example-collection"],
 *                 Permission: ["aoss:DescribeCollectionItems"],
 *             },
 *         ],
 *         Principal: [current&#46;then(current => current&#46;arn)],
 *     }]),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example = aws.opensearch.ServerlessAccessPolicy("example",
 *     name="example",
 *     type="data",
 *     description="read-only permissions",
 *     policy=json.dumps([{
 *         "Rules": [
 *             {
 *                 "ResourceType": "index",
 *                 "Resource": ["index/example-collection/*"],
 *                 "Permission": [
 *                     "aoss:DescribeIndex",
 *                     "aoss:ReadDocument",
 *                 ],
 *             },
 *             {
 *                 "ResourceType": "collection",
 *                 "Resource": ["collection/example-collection"],
 *                 "Permission": ["aoss:DescribeCollectionItems"],
 *             },
 *         ],
 *         "Principal": [current&#46;arn],
 *     }]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var example = new Aws.OpenSearch.ServerlessAccessPolicy("example", new()
 *     {
 *         Name = "example",
 *         Type = "data",
 *         Description = "read-only permissions",
 *         Policy = JsonSerializer.Serialize(new[]
 *         {
 *             new Dictionary<string, object?>
 *             {
 *                 ["Rules"] = new[]
 *                 {
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["ResourceType"] = "index",
 *                         ["Resource"] = new[]
 *                         {
 *                             "index/example-collection/*",
 *                         },
 *                         ["Permission"] = new[]
 *                         {
 *                             "aoss:DescribeIndex",
 *                             "aoss:ReadDocument",
 *                         },
 *                     },
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["ResourceType"] = "collection",
 *                         ["Resource"] = new[]
 *                         {
 *                             "collection/example-collection",
 *                         },
 *                         ["Permission"] = new[]
 *                         {
 *                             "aoss:DescribeCollectionItems",
 *                         },
 *                     },
 *                 },
 *                 ["Principal"] = new[]
 *                 {
 *                     current.Apply(getCallerIdentityResult => getCallerIdentityResult.Arn),
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal([]map[string]interface{}{
 * 			map[string]interface{}{
 * 				"Rules": []interface{}{
 * 					map[string]interface{}{
 * 						"ResourceType": "index",
 * 						"Resource": []string{
 * 							"index/example-collection/*",
 * 						},
 * 						"Permission": []string{
 * 							"aoss:DescribeIndex",
 * 							"aoss:ReadDocument",
 * 						},
 * 					},
 * 					map[string]interface{}{
 * 						"ResourceType": "collection",
 * 						"Resource": []string{
 * 							"collection/example-collection",
 * 						},
 * 						"Permission": []string{
 * 							"aoss:DescribeCollectionItems",
 * 						},
 * 					},
 * 				},
 * 				"Principal": []*string{
 * 					current.Arn,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = opensearch.NewServerlessAccessPolicy(ctx, "example", &opensearch.ServerlessAccessPolicyArgs{
 * 			Name:        pulumi.String("example"),
 * 			Type:        pulumi.String("data"),
 * 			Description: pulumi.String("read-only permissions"),
 * 			Policy:      pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicy;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new ServerlessAccessPolicy("example", ServerlessAccessPolicyArgs.builder()
 *             .name("example")
 *             .type("data")
 *             .description("read-only permissions")
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty("Rules", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "index"),
 *                             jsonProperty("Resource", jsonArray("index/example-collection/*")),
 *                             jsonProperty("Permission", jsonArray(
 *                                 "aoss:DescribeIndex",
 *                                 "aoss:ReadDocument"
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "collection"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection")),
 *                             jsonProperty("Permission", jsonArray("aoss:DescribeCollectionItems"))
 *                         )
 *                     )),
 *                     jsonProperty("Principal", jsonArray(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn())))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:opensearch:ServerlessAccessPolicy
 *     properties:
 *       name: example
 *       type: data
 *       description: read-only permissions
 *       policy:
 *         fn::toJSON:
 *           - Rules:
 *               - ResourceType: index
 *                 Resource:
 *                   - index/example-collection/*
 *                 Permission:
 *                   - aoss:DescribeIndex
 *                   - aoss:ReadDocument
 *               - ResourceType: collection
 *                 Resource:
 *                   - collection/example-collection
 *                 Permission:
 *                   - aoss:DescribeCollectionItems
 *             Principal:
 *               - ${current.arn}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Grant SAML identity permissions
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.opensearch.ServerlessAccessPolicy("example", {
 *     name: "example",
 *     type: "data",
 *     description: "saml permissions",
 *     policy: JSON.stringify([{
 *         Rules: [
 *             {
 *                 ResourceType: "index",
 *                 Resource: ["index/example-collection/*"],
 *                 Permission: ["aoss:*"],
 *             },
 *             {
 *                 ResourceType: "collection",
 *                 Resource: ["collection/example-collection"],
 *                 Permission: ["aoss:*"],
 *             },
 *         ],
 *         Principal: [
 *             "saml/123456789012/myprovider/user/Annie",
 *             "saml/123456789012/anotherprovider/group/Accounting",
 *         ],
 *     }]),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.opensearch.ServerlessAccessPolicy("example",
 *     name="example",
 *     type="data",
 *     description="saml permissions",
 *     policy=json.dumps([{
 *         "Rules": [
 *             {
 *                 "ResourceType": "index",
 *                 "Resource": ["index/example-collection/*"],
 *                 "Permission": ["aoss:*"],
 *             },
 *             {
 *                 "ResourceType": "collection",
 *                 "Resource": ["collection/example-collection"],
 *                 "Permission": ["aoss:*"],
 *             },
 *         ],
 *         "Principal": [
 *             "saml/123456789012/myprovider/user/Annie",
 *             "saml/123456789012/anotherprovider/group/Accounting",
 *         ],
 *     }]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.OpenSearch.ServerlessAccessPolicy("example", new()
 *     {
 *         Name = "example",
 *         Type = "data",
 *         Description = "saml permissions",
 *         Policy = JsonSerializer.Serialize(new[]
 *         {
 *             new Dictionary<string, object?>
 *             {
 *                 ["Rules"] = new[]
 *                 {
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["ResourceType"] = "index",
 *                         ["Resource"] = new[]
 *                         {
 *                             "index/example-collection/*",
 *                         },
 *                         ["Permission"] = new[]
 *                         {
 *                             "aoss:*",
 *                         },
 *                     },
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["ResourceType"] = "collection",
 *                         ["Resource"] = new[]
 *                         {
 *                             "collection/example-collection",
 *                         },
 *                         ["Permission"] = new[]
 *                         {
 *                             "aoss:*",
 *                         },
 *                     },
 *                 },
 *                 ["Principal"] = new[]
 *                 {
 *                     "saml/123456789012/myprovider/user/Annie",
 *                     "saml/123456789012/anotherprovider/group/Accounting",
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal([]map[string]interface{}{
 * 			map[string]interface{}{
 * 				"Rules": []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"ResourceType": "index",
 * 						"Resource": []string{
 * 							"index/example-collection/*",
 * 						},
 * 						"Permission": []string{
 * 							"aoss:*",
 * 						},
 * 					},
 * 					map[string]interface{}{
 * 						"ResourceType": "collection",
 * 						"Resource": []string{
 * 							"collection/example-collection",
 * 						},
 * 						"Permission": []string{
 * 							"aoss:*",
 * 						},
 * 					},
 * 				},
 * 				"Principal": []string{
 * 					"saml/123456789012/myprovider/user/Annie",
 * 					"saml/123456789012/anotherprovider/group/Accounting",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = opensearch.NewServerlessAccessPolicy(ctx, "example", &opensearch.ServerlessAccessPolicyArgs{
 * 			Name:        pulumi.String("example"),
 * 			Type:        pulumi.String("data"),
 * 			Description: pulumi.String("saml permissions"),
 * 			Policy:      pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicy;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessAccessPolicy("example", ServerlessAccessPolicyArgs.builder()
 *             .name("example")
 *             .type("data")
 *             .description("saml permissions")
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty("Rules", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "index"),
 *                             jsonProperty("Resource", jsonArray("index/example-collection/*")),
 *                             jsonProperty("Permission", jsonArray("aoss:*"))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "collection"),
 *                             jsonProperty("Resource", jsonArray("collection/example-collection")),
 *                             jsonProperty("Permission", jsonArray("aoss:*"))
 *                         )
 *                     )),
 *                     jsonProperty("Principal", jsonArray(
 *                         "saml/123456789012/myprovider/user/Annie",
 *                         "saml/123456789012/anotherprovider/group/Accounting"
 *                     ))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:opensearch:ServerlessAccessPolicy
 *     properties:
 *       name: example
 *       type: data
 *       description: saml permissions
 *       policy:
 *         fn::toJSON:
 *           - Rules:
 *               - ResourceType: index
 *                 Resource:
 *                   - index/example-collection/*
 *                 Permission:
 *                   - aoss:*
 *               - ResourceType: collection
 *                 Resource:
 *                   - collection/example-collection
 *                 Permission:
 *                   - aoss:*
 *             Principal:
 *               - saml/123456789012/myprovider/user/Annie
 *               - saml/123456789012/anotherprovider/group/Accounting
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import OpenSearchServerless Access Policy using the `name` and `type` arguments separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:opensearch/serverlessAccessPolicy:ServerlessAccessPolicy example example/data
 * ```
 * */*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
 */
public class ServerlessAccessPolicy internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.ServerlessAccessPolicy,
) : KotlinCustomResource(javaResource, ServerlessAccessPolicyMapper) {
    /**
     * Description of the policy. Typically used to store information about the permissions defined in the policy.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * JSON policy document to use as the content for the new policy
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * Version of the policy.
     */
    public val policyVersion: Output<String>
        get() = javaResource.policyVersion().applyValue({ args0 -> args0 })

    /**
     * Type of access policy. Must be `data`.
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerlessAccessPolicyMapper : ResourceMapper<ServerlessAccessPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.ServerlessAccessPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ServerlessAccessPolicy =
        ServerlessAccessPolicy(javaResource as com.pulumi.aws.opensearch.ServerlessAccessPolicy)
}

/**
 * @see [ServerlessAccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerlessAccessPolicy].
 */
public suspend fun serverlessAccessPolicy(
    name: String,
    block: suspend ServerlessAccessPolicyResourceBuilder.() -> Unit,
): ServerlessAccessPolicy {
    val builder = ServerlessAccessPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerlessAccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverlessAccessPolicy(name: String): ServerlessAccessPolicy {
    val builder = ServerlessAccessPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
