@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.kotlin.outputs.ServerlessCollectionTimeouts
import com.pulumi.aws.opensearch.kotlin.outputs.ServerlessCollectionTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ServerlessCollection].
 */
@PulumiTagMarker
public class ServerlessCollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerlessCollectionArgs = ServerlessCollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerlessCollectionArgsBuilder.() -> Unit) {
        val builder = ServerlessCollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerlessCollection {
        val builtJavaResource = com.pulumi.aws.opensearch.ServerlessCollection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerlessCollection(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS OpenSearch Serverless Collection.
 * > **NOTE:** An `aws.opensearch.ServerlessCollection` cannot be created without having an applicable encryption security policy. Use the `depends_on` meta-argument to define this dependency.
 * > **NOTE:** An `aws.opensearch.ServerlessCollection` is not accessible without configuring an applicable network security policy. Data cannot be accessed without configuring an applicable data access policy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.opensearch.ServerlessSecurityPolicy("example", {
 *     name: "example",
 *     type: "encryption",
 *     policy: JSON.stringify({
 *         Rules: [{
 *             Resource: ["collection/example"],
 *             ResourceType: "collection",
 *         }],
 *         AWSOwnedKey: true,
 *     }),
 * });
 * const exampleServerlessCollection = new aws.opensearch.ServerlessCollection("example", {name: "example"}, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.opensearch.ServerlessSecurityPolicy("example",
 *     name="example",
 *     type="encryption",
 *     policy=json.dumps({
 *         "Rules": [{
 *             "Resource": ["collection/example"],
 *             "ResourceType": "collection",
 *         }],
 *         "AWSOwnedKey": True,
 *     }))
 * example_serverless_collection = aws.opensearch.ServerlessCollection("example", name="example",
 * opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.OpenSearch.ServerlessSecurityPolicy("example", new()
 *     {
 *         Name = "example",
 *         Type = "encryption",
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Rules"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Resource"] = new[]
 *                     {
 *                         "collection/example",
 *                     },
 *                     ["ResourceType"] = "collection",
 *                 },
 *             },
 *             ["AWSOwnedKey"] = true,
 *         }),
 *     });
 *     var exampleServerlessCollection = new Aws.OpenSearch.ServerlessCollection("example", new()
 *     {
 *         Name = "example",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Rules": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Resource": []string{
 * 						"collection/example",
 * 					},
 * 					"ResourceType": "collection",
 * 				},
 * 			},
 * 			"AWSOwnedKey": true,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		example, err := opensearch.NewServerlessSecurityPolicy(ctx, "example", &opensearch.ServerlessSecurityPolicyArgs{
 * 			Name:   pulumi.String("example"),
 * 			Type:   pulumi.String("encryption"),
 * 			Policy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = opensearch.NewServerlessCollection(ctx, "example", &opensearch.ServerlessCollectionArgs{
 * 			Name: pulumi.String("example"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import com.pulumi.aws.opensearch.ServerlessCollection;
 * import com.pulumi.aws.opensearch.ServerlessCollectionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .name("example")
 *             .type("encryption")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Rules", jsonArray(jsonObject(
 *                         jsonProperty("Resource", jsonArray("collection/example")),
 *                         jsonProperty("ResourceType", "collection")
 *                     ))),
 *                     jsonProperty("AWSOwnedKey", true)
 *                 )))
 *             .build());
 *         var exampleServerlessCollection = new ServerlessCollection("exampleServerlessCollection", ServerlessCollectionArgs.builder()
 *             .name("example")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:opensearch:ServerlessSecurityPolicy
 *     properties:
 *       name: example
 *       type: encryption
 *       policy:
 *         fn::toJSON:
 *           Rules:
 *             - Resource:
 *                 - collection/example
 *               ResourceType: collection
 *           AWSOwnedKey: true
 *   exampleServerlessCollection:
 *     type: aws:opensearch:ServerlessCollection
 *     name: example
 *     properties:
 *       name: example
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import OpenSearchServerless Collection using the `id`. For example:
 * ```sh
 * $ pulumi import aws:opensearch/serverlessCollection:ServerlessCollection example example
 * ```
 */
public class ServerlessCollection internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.ServerlessCollection,
) : KotlinCustomResource(javaResource, ServerlessCollectionMapper) {
    /**
     * Amazon Resource Name (ARN) of the collection.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Collection-specific endpoint used to submit index, search, and data upload requests to an OpenSearch Serverless collection.
     */
    public val collectionEndpoint: Output<String>
        get() = javaResource.collectionEndpoint().applyValue({ args0 -> args0 })

    /**
     * Collection-specific endpoint used to access OpenSearch Dashboards.
     */
    public val dashboardEndpoint: Output<String>
        get() = javaResource.dashboardEndpoint().applyValue({ args0 -> args0 })

    /**
     * Description of the collection.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the Amazon Web Services KMS key used to encrypt the collection.
     */
    public val kmsKeyArn: Output<String>
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0 })

    /**
     * Name of the collection.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Indicates whether standby replicas should be used for a collection. One of `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
     */
    public val standbyReplicas: Output<String>
        get() = javaResource.standbyReplicas().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<ServerlessCollectionTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Type of collection. One of `SEARCH`, `TIMESERIES`, or `VECTORSEARCH`. Defaults to `TIMESERIES`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerlessCollectionMapper : ResourceMapper<ServerlessCollection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.ServerlessCollection::class == javaResource::class

    override fun map(javaResource: Resource): ServerlessCollection = ServerlessCollection(
        javaResource
            as com.pulumi.aws.opensearch.ServerlessCollection,
    )
}

/**
 * @see [ServerlessCollection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerlessCollection].
 */
public suspend fun serverlessCollection(
    name: String,
    block: suspend ServerlessCollectionResourceBuilder.() -> Unit,
): ServerlessCollection {
    val builder = ServerlessCollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerlessCollection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverlessCollection(name: String): ServerlessCollection {
    val builder = ServerlessCollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
