@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.ServerlessCollectionArgs.builder
import com.pulumi.aws.opensearch.kotlin.inputs.ServerlessCollectionTimeoutsArgs
import com.pulumi.aws.opensearch.kotlin.inputs.ServerlessCollectionTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS OpenSearch Serverless Collection.
 * > **NOTE:** An `aws.opensearch.ServerlessCollection` cannot be created without having an applicable encryption security policy. Use the `depends_on` meta-argument to define this dependency.
 * > **NOTE:** An `aws.opensearch.ServerlessCollection` is not accessible without configuring an applicable network security policy. Data cannot be accessed without configuring an applicable data access policy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.opensearch.ServerlessSecurityPolicy("example", {
 *     name: "example",
 *     type: "encryption",
 *     policy: JSON.stringify({
 *         Rules: [{
 *             Resource: ["collection/example"],
 *             ResourceType: "collection",
 *         }],
 *         AWSOwnedKey: true,
 *     }),
 * });
 * const exampleServerlessCollection = new aws.opensearch.ServerlessCollection("example", {name: "example"}, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.opensearch.ServerlessSecurityPolicy("example",
 *     name="example",
 *     type="encryption",
 *     policy=json.dumps({
 *         "Rules": [{
 *             "Resource": ["collection/example"],
 *             "ResourceType": "collection",
 *         }],
 *         "AWSOwnedKey": True,
 *     }))
 * example_serverless_collection = aws.opensearch.ServerlessCollection("example", name="example",
 * opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.OpenSearch.ServerlessSecurityPolicy("example", new()
 *     {
 *         Name = "example",
 *         Type = "encryption",
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Rules"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Resource"] = new[]
 *                     {
 *                         "collection/example",
 *                     },
 *                     ["ResourceType"] = "collection",
 *                 },
 *             },
 *             ["AWSOwnedKey"] = true,
 *         }),
 *     });
 *     var exampleServerlessCollection = new Aws.OpenSearch.ServerlessCollection("example", new()
 *     {
 *         Name = "example",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Rules": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Resource": []string{
 * 						"collection/example",
 * 					},
 * 					"ResourceType": "collection",
 * 				},
 * 			},
 * 			"AWSOwnedKey": true,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		example, err := opensearch.NewServerlessSecurityPolicy(ctx, "example", &opensearch.ServerlessSecurityPolicyArgs{
 * 			Name:   pulumi.String("example"),
 * 			Type:   pulumi.String("encryption"),
 * 			Policy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = opensearch.NewServerlessCollection(ctx, "example", &opensearch.ServerlessCollectionArgs{
 * 			Name: pulumi.String("example"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicy;
 * import com.pulumi.aws.opensearch.ServerlessSecurityPolicyArgs;
 * import com.pulumi.aws.opensearch.ServerlessCollection;
 * import com.pulumi.aws.opensearch.ServerlessCollectionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessSecurityPolicy("example", ServerlessSecurityPolicyArgs.builder()
 *             .name("example")
 *             .type("encryption")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Rules", jsonArray(jsonObject(
 *                         jsonProperty("Resource", jsonArray("collection/example")),
 *                         jsonProperty("ResourceType", "collection")
 *                     ))),
 *                     jsonProperty("AWSOwnedKey", true)
 *                 )))
 *             .build());
 *         var exampleServerlessCollection = new ServerlessCollection("exampleServerlessCollection", ServerlessCollectionArgs.builder()
 *             .name("example")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:opensearch:ServerlessSecurityPolicy
 *     properties:
 *       name: example
 *       type: encryption
 *       policy:
 *         fn::toJSON:
 *           Rules:
 *             - Resource:
 *                 - collection/example
 *               ResourceType: collection
 *           AWSOwnedKey: true
 *   exampleServerlessCollection:
 *     type: aws:opensearch:ServerlessCollection
 *     name: example
 *     properties:
 *       name: example
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import OpenSearchServerless Collection using the `id`. For example:
 * ```sh
 * $ pulumi import aws:opensearch/serverlessCollection:ServerlessCollection example example
 * ```
 * @property description Description of the collection.
 * @property name Name of the collection.
 * The following arguments are optional:
 * @property standbyReplicas Indicates whether standby replicas should be used for a collection. One of `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
 * @property tags A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 * @property type Type of collection. One of `SEARCH`, `TIMESERIES`, or `VECTORSEARCH`. Defaults to `TIMESERIES`.
 */
public data class ServerlessCollectionArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val standbyReplicas: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<ServerlessCollectionTimeoutsArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.ServerlessCollectionArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.ServerlessCollectionArgs =
        com.pulumi.aws.opensearch.ServerlessCollectionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .standbyReplicas(standbyReplicas?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessCollectionArgs].
 */
@PulumiTagMarker
public class ServerlessCollectionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var standbyReplicas: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<ServerlessCollectionTimeoutsArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Description of the collection.
     */
    @JvmName("fnmxllcnewoacbjn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the collection.
     * The following arguments are optional:
     */
    @JvmName("qnxuqwfswwucraxe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether standby replicas should be used for a collection. One of `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
     */
    @JvmName("fffefyaddvojnxkl")
    public suspend fun standbyReplicas(`value`: Output<String>) {
        this.standbyReplicas = value
    }

    /**
     * @param value A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hjdftxhoaxijuccp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("dmuswgysqqudwetm")
    public suspend fun timeouts(`value`: Output<ServerlessCollectionTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Type of collection. One of `SEARCH`, `TIMESERIES`, or `VECTORSEARCH`. Defaults to `TIMESERIES`.
     */
    @JvmName("yghqovnjbvahbnra")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Description of the collection.
     */
    @JvmName("ptpanirbwucfmdul")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the collection.
     * The following arguments are optional:
     */
    @JvmName("gbpukjfbgqrphhta")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates whether standby replicas should be used for a collection. One of `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
     */
    @JvmName("ssisxuehrodshixy")
    public suspend fun standbyReplicas(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standbyReplicas = mapped
    }

    /**
     * @param value A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wibuqyvidceaytmo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the collection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uadwxdrtfawuehdy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("eqlmfmsmvodkvggj")
    public suspend fun timeouts(`value`: ServerlessCollectionTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ljecppwerjexluah")
    public suspend fun timeouts(argument: suspend ServerlessCollectionTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessCollectionTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value Type of collection. One of `SEARCH`, `TIMESERIES`, or `VECTORSEARCH`. Defaults to `TIMESERIES`.
     */
    @JvmName("arrijaemuekkholt")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServerlessCollectionArgs = ServerlessCollectionArgs(
        description = description,
        name = name,
        standbyReplicas = standbyReplicas,
        tags = tags,
        timeouts = timeouts,
        type = type,
    )
}
