@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.ServerlessLifecyclePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS OpenSearch Serverless Lifecycle Policy. See AWS documentation for [lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html).
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.opensearch.ServerlessLifecyclePolicy("example", {
 *     name: "example",
 *     type: "retention",
 *     policy: JSON.stringify({
 *         Rules: [
 *             {
 *                 ResourceType: "index",
 *                 Resource: ["index/autoparts-inventory/*"],
 *                 MinIndexRetention: "81d",
 *             },
 *             {
 *                 ResourceType: "index",
 *                 Resource: ["index/sales/orders*"],
 *                 NoMinIndexRetention: true,
 *             },
 *         ],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.opensearch.ServerlessLifecyclePolicy("example",
 *     name="example",
 *     type="retention",
 *     policy=json.dumps({
 *         "Rules": [
 *             {
 *                 "ResourceType": "index",
 *                 "Resource": ["index/autoparts-inventory/*"],
 *                 "MinIndexRetention": "81d",
 *             },
 *             {
 *                 "ResourceType": "index",
 *                 "Resource": ["index/sales/orders*"],
 *                 "NoMinIndexRetention": True,
 *             },
 *         ],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.OpenSearch.ServerlessLifecyclePolicy("example", new()
 *     {
 *         Name = "example",
 *         Type = "retention",
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Rules"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["ResourceType"] = "index",
 *                     ["Resource"] = new[]
 *                     {
 *                         "index/autoparts-inventory/*",
 *                     },
 *                     ["MinIndexRetention"] = "81d",
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["ResourceType"] = "index",
 *                     ["Resource"] = new[]
 *                     {
 *                         "index/sales/orders*",
 *                     },
 *                     ["NoMinIndexRetention"] = true,
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Rules": []interface{}{
 * 				map[string]interface{}{
 * 					"ResourceType": "index",
 * 					"Resource": []string{
 * 						"index/autoparts-inventory/*",
 * 					},
 * 					"MinIndexRetention": "81d",
 * 				},
 * 				map[string]interface{}{
 * 					"ResourceType": "index",
 * 					"Resource": []string{
 * 						"index/sales/orders*",
 * 					},
 * 					"NoMinIndexRetention": true,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = opensearch.NewServerlessLifecyclePolicy(ctx, "example", &opensearch.ServerlessLifecyclePolicyArgs{
 * 			Name:   pulumi.String("example"),
 * 			Type:   pulumi.String("retention"),
 * 			Policy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessLifecyclePolicy;
 * import com.pulumi.aws.opensearch.ServerlessLifecyclePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessLifecyclePolicy("example", ServerlessLifecyclePolicyArgs.builder()
 *             .name("example")
 *             .type("retention")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Rules", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "index"),
 *                             jsonProperty("Resource", jsonArray("index/autoparts-inventory/*")),
 *                             jsonProperty("MinIndexRetention", "81d")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("ResourceType", "index"),
 *                             jsonProperty("Resource", jsonArray("index/sales/orders*")),
 *                             jsonProperty("NoMinIndexRetention", true)
 *                         )
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:opensearch:ServerlessLifecyclePolicy
 *     properties:
 *       name: example
 *       type: retention
 *       policy:
 *         fn::toJSON:
 *           Rules:
 *             - ResourceType: index
 *               Resource:
 *                 - index/autoparts-inventory/*
 *               MinIndexRetention: 81d
 *             - ResourceType: index
 *               Resource:
 *                 - index/sales/orders*
 *               NoMinIndexRetention: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import OpenSearch Serverless Lifecycle Policy using the `name` and `type` arguments separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:opensearch/serverlessLifecyclePolicy:ServerlessLifecyclePolicy example example/retention
 * ```
 * @property description Description of the policy.
 * @property name Name of the policy.
 * @property policy JSON policy document to use as the content for the new policy.
 * @property type Type of lifecycle policy. Must be `retention`.
 * The following arguments are optional:
 * */*/*/*/*/*/
 */
public data class ServerlessLifecyclePolicyArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.ServerlessLifecyclePolicyArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.ServerlessLifecyclePolicyArgs =
        com.pulumi.aws.opensearch.ServerlessLifecyclePolicyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessLifecyclePolicyArgs].
 */
@PulumiTagMarker
public class ServerlessLifecyclePolicyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Description of the policy.
     */
    @JvmName("qxegpdvnswupaxmx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the policy.
     */
    @JvmName("rlfxdrysswnkoqnl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value JSON policy document to use as the content for the new policy.
     */
    @JvmName("vdfxnvxovsglhykl")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Type of lifecycle policy. Must be `retention`.
     * The following arguments are optional:
     */
    @JvmName("cskdtmhydnefatbx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Description of the policy.
     */
    @JvmName("fjjvvbakyupimsag")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the policy.
     */
    @JvmName("lppndbyqnkayhxim")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value JSON policy document to use as the content for the new policy.
     */
    @JvmName("xnfxaudcdkcjawjm")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Type of lifecycle policy. Must be `retention`.
     * The following arguments are optional:
     */
    @JvmName("meusvmmdcwoghtqd")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServerlessLifecyclePolicyArgs = ServerlessLifecyclePolicyArgs(
        description = description,
        name = name,
        policy = policy,
        type = type,
    )
}
