@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.kotlin.outputs.ServerlessSecurityConfigSamlOptions
import com.pulumi.aws.opensearch.kotlin.outputs.ServerlessSecurityConfigSamlOptions.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerlessSecurityConfig].
 */
@PulumiTagMarker
public class ServerlessSecurityConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerlessSecurityConfigArgs = ServerlessSecurityConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerlessSecurityConfigArgsBuilder.() -> Unit) {
        val builder = ServerlessSecurityConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerlessSecurityConfig {
        val builtJavaResource =
            com.pulumi.aws.opensearch.ServerlessSecurityConfig(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerlessSecurityConfig(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS OpenSearch Serverless Security Config.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import OpenSearchServerless Access Policy using the `name` argument prefixed with the string `saml/account_id/`. For example:
 * ```sh
 * $ pulumi import aws:opensearch/serverlessSecurityConfig:ServerlessSecurityConfig example saml/123456789012/example
 * ```
 */
public class ServerlessSecurityConfig internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.ServerlessSecurityConfig,
) : KotlinCustomResource(javaResource, ServerlessSecurityConfigMapper) {
    /**
     * Version of the configuration.
     */
    public val configVersion: Output<String>
        get() = javaResource.configVersion().applyValue({ args0 -> args0 })

    /**
     * Description of the security configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration block for SAML options.
     */
    public val samlOptions: Output<ServerlessSecurityConfigSamlOptions>?
        get() = javaResource.samlOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Type of configuration. Must be `saml`.
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerlessSecurityConfigMapper : ResourceMapper<ServerlessSecurityConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.ServerlessSecurityConfig::class == javaResource::class

    override fun map(javaResource: Resource): ServerlessSecurityConfig =
        ServerlessSecurityConfig(javaResource as com.pulumi.aws.opensearch.ServerlessSecurityConfig)
}

/**
 * @see [ServerlessSecurityConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerlessSecurityConfig].
 */
public suspend fun serverlessSecurityConfig(
    name: String,
    block: suspend ServerlessSecurityConfigResourceBuilder.() -> Unit,
): ServerlessSecurityConfig {
    val builder = ServerlessSecurityConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerlessSecurityConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverlessSecurityConfig(name: String): ServerlessSecurityConfig {
    val builder = ServerlessSecurityConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
