@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.ServerlessSecurityConfigArgs.builder
import com.pulumi.aws.opensearch.kotlin.inputs.ServerlessSecurityConfigSamlOptionsArgs
import com.pulumi.aws.opensearch.kotlin.inputs.ServerlessSecurityConfigSamlOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS OpenSearch Serverless Security Config.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import OpenSearchServerless Access Policy using the `name` argument prefixed with the string `saml/account_id/`. For example:
 * ```sh
 * $ pulumi import aws:opensearch/serverlessSecurityConfig:ServerlessSecurityConfig example saml/123456789012/example
 * ```
 * @property description Description of the security configuration.
 * @property name Name of the policy.
 * @property samlOptions Configuration block for SAML options.
 * @property type Type of configuration. Must be `saml`.
 * The following arguments are optional:
 */
public data class ServerlessSecurityConfigArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val samlOptions: Output<ServerlessSecurityConfigSamlOptionsArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opensearch.ServerlessSecurityConfigArgs> {
    override fun toJava(): com.pulumi.aws.opensearch.ServerlessSecurityConfigArgs =
        com.pulumi.aws.opensearch.ServerlessSecurityConfigArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .samlOptions(samlOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessSecurityConfigArgs].
 */
@PulumiTagMarker
public class ServerlessSecurityConfigArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var samlOptions: Output<ServerlessSecurityConfigSamlOptionsArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Description of the security configuration.
     */
    @JvmName("oqxugekmgqjdxqmq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the policy.
     */
    @JvmName("rhkafeoelkkxgnyc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for SAML options.
     */
    @JvmName("atcxhajceksxqegl")
    public suspend fun samlOptions(`value`: Output<ServerlessSecurityConfigSamlOptionsArgs>) {
        this.samlOptions = value
    }

    /**
     * @param value Type of configuration. Must be `saml`.
     * The following arguments are optional:
     */
    @JvmName("eaqengrcpydehcoi")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Description of the security configuration.
     */
    @JvmName("lnisffexxadtnhej")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the policy.
     */
    @JvmName("hwlbqnawwedgycob")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block for SAML options.
     */
    @JvmName("svbqxiovwssknoaw")
    public suspend fun samlOptions(`value`: ServerlessSecurityConfigSamlOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samlOptions = mapped
    }

    /**
     * @param argument Configuration block for SAML options.
     */
    @JvmName("aljxaxxqllckgarq")
    public suspend fun samlOptions(argument: suspend ServerlessSecurityConfigSamlOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessSecurityConfigSamlOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.samlOptions = mapped
    }

    /**
     * @param value Type of configuration. Must be `saml`.
     * The following arguments are optional:
     */
    @JvmName("mfjawbmlvpofhyif")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServerlessSecurityConfigArgs = ServerlessSecurityConfigArgs(
        description = description,
        name = name,
        samlOptions = samlOptions,
        type = type,
    )
}
