@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.kotlin.outputs.ServerlessVpcEndpointTimeouts
import com.pulumi.aws.opensearch.kotlin.outputs.ServerlessVpcEndpointTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ServerlessVpcEndpoint].
 */
@PulumiTagMarker
public class ServerlessVpcEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerlessVpcEndpointArgs = ServerlessVpcEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerlessVpcEndpointArgsBuilder.() -> Unit) {
        val builder = ServerlessVpcEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerlessVpcEndpoint {
        val builtJavaResource = com.pulumi.aws.opensearch.ServerlessVpcEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerlessVpcEndpoint(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS OpenSearchServerless VPC Endpoint.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.opensearch.ServerlessVpcEndpoint("example", {
 *     name: "myendpoint",
 *     subnetIds: [exampleAwsSubnet&#46;id],
 *     vpcId: exampleAwsVpc.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.opensearch.ServerlessVpcEndpoint("example",
 *     name="myendpoint",
 *     subnet_ids=[example_aws_subnet["id"]],
 *     vpc_id=example_aws_vpc["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.OpenSearch.ServerlessVpcEndpoint("example", new()
 *     {
 *         Name = "myendpoint",
 *         SubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         VpcId = exampleAwsVpc.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opensearch.NewServerlessVpcEndpoint(ctx, "example", &opensearch.ServerlessVpcEndpointArgs{
 * 			Name: pulumi.String("myendpoint"),
 * 			SubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			VpcId: pulumi.Any(exampleAwsVpc.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessVpcEndpoint;
 * import com.pulumi.aws.opensearch.ServerlessVpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessVpcEndpoint("example", ServerlessVpcEndpointArgs.builder()
 *             .name("myendpoint")
 *             .subnetIds(exampleAwsSubnet.id())
 *             .vpcId(exampleAwsVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:opensearch:ServerlessVpcEndpoint
 *     properties:
 *       name: myendpoint
 *       subnetIds:
 *         - ${exampleAwsSubnet.id}
 *       vpcId: ${exampleAwsVpc.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import OpenSearchServerless Vpc Endpointa using the `id`. For example:
 * ```sh
 * $ pulumi import aws:opensearch/serverlessVpcEndpoint:ServerlessVpcEndpoint example vpce-8012925589
 * ```
 */
public class ServerlessVpcEndpoint internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.ServerlessVpcEndpoint,
) : KotlinCustomResource(javaResource, ServerlessVpcEndpointMapper) {
    /**
     * Name of the interface endpoint.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * One or more security groups that define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint. Up to 5 security groups can be provided.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * One or more subnet IDs from which you'll access OpenSearch Serverless. Up to 6 subnets can be provided.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    public val timeouts: Output<ServerlessVpcEndpointTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * ID of the VPC from which you'll access OpenSearch Serverless.
     * The following arguments are optional:
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object ServerlessVpcEndpointMapper : ResourceMapper<ServerlessVpcEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.ServerlessVpcEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): ServerlessVpcEndpoint =
        ServerlessVpcEndpoint(javaResource as com.pulumi.aws.opensearch.ServerlessVpcEndpoint)
}

/**
 * @see [ServerlessVpcEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerlessVpcEndpoint].
 */
public suspend fun serverlessVpcEndpoint(
    name: String,
    block: suspend ServerlessVpcEndpointResourceBuilder.() -> Unit,
): ServerlessVpcEndpoint {
    val builder = ServerlessVpcEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerlessVpcEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverlessVpcEndpoint(name: String): ServerlessVpcEndpoint {
    val builder = ServerlessVpcEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
