@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opensearch.kotlin

import com.pulumi.aws.opensearch.kotlin.outputs.VpcEndpointVpcOptions
import com.pulumi.aws.opensearch.kotlin.outputs.VpcEndpointVpcOptions.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcEndpoint].
 */
@PulumiTagMarker
public class VpcEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointArgs = VpcEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointArgsBuilder.() -> Unit) {
        val builder = VpcEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcEndpoint {
        val builtJavaResource = com.pulumi.aws.opensearch.VpcEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcEndpoint(builtJavaResource)
    }
}

/**
 * Manages an [AWS Opensearch VPC Endpoint](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateVpcEndpoint.html). Creates an Amazon OpenSearch Service-managed VPC endpoint.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.opensearch.VpcEndpoint("foo", {
 *     domainArn: domain1.arn,
 *     vpcOptions: {
 *         securityGroupIds: [
 *             test.id,
 *             test2.id,
 *         ],
 *         subnetIds: [
 *             testAwsSubnet.id,
 *             test2AwsSubnet.id,
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.opensearch.VpcEndpoint("foo",
 *     domain_arn=domain1["arn"],
 *     vpc_options={
 *         "security_group_ids": [
 *             test["id"],
 *             test2["id"],
 *         ],
 *         "subnet_ids": [
 *             test_aws_subnet["id"],
 *             test2_aws_subnet["id"],
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.OpenSearch.VpcEndpoint("foo", new()
 *     {
 *         DomainArn = domain1.Arn,
 *         VpcOptions = new Aws.OpenSearch.Inputs.VpcEndpointVpcOptionsArgs
 *         {
 *             SecurityGroupIds = new[]
 *             {
 *                 test.Id,
 *                 test2.Id,
 *             },
 *             SubnetIds = new[]
 *             {
 *                 testAwsSubnet.Id,
 *                 test2AwsSubnet.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := opensearch.NewVpcEndpoint(ctx, "foo", &opensearch.VpcEndpointArgs{
 * 			DomainArn: pulumi.Any(domain1.Arn),
 * 			VpcOptions: &opensearch.VpcEndpointVpcOptionsArgs{
 * 				SecurityGroupIds: pulumi.StringArray{
 * 					test.Id,
 * 					test2.Id,
 * 				},
 * 				SubnetIds: pulumi.StringArray{
 * 					testAwsSubnet.Id,
 * 					test2AwsSubnet.Id,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.VpcEndpoint;
 * import com.pulumi.aws.opensearch.VpcEndpointArgs;
 * import com.pulumi.aws.opensearch.inputs.VpcEndpointVpcOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new VpcEndpoint("foo", VpcEndpointArgs.builder()
 *             .domainArn(domain1.arn())
 *             .vpcOptions(VpcEndpointVpcOptionsArgs.builder()
 *                 .securityGroupIds(
 *                     test.id(),
 *                     test2.id())
 *                 .subnetIds(
 *                     testAwsSubnet.id(),
 *                     test2AwsSubnet.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:opensearch:VpcEndpoint
 *     properties:
 *       domainArn: ${domain1.arn}
 *       vpcOptions:
 *         securityGroupIds:
 *           - ${test.id}
 *           - ${test2.id}
 *         subnetIds:
 *           - ${testAwsSubnet.id}
 *           - ${test2AwsSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import OpenSearch VPC endpoint connections using the `id`. For example:
 * ```sh
 * $ pulumi import aws:opensearch/vpcEndpoint:VpcEndpoint example endpoint-id
 * ```
 */
public class VpcEndpoint internal constructor(
    override val javaResource: com.pulumi.aws.opensearch.VpcEndpoint,
) : KotlinCustomResource(javaResource, VpcEndpointMapper) {
    /**
     * Specifies the Amazon Resource Name (ARN) of the domain to create the endpoint for
     */
    public val domainArn: Output<String>
        get() = javaResource.domainArn().applyValue({ args0 -> args0 })

    /**
     * The connection endpoint ID for connecting to the domain.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * Options to specify the subnets and security groups for the endpoint.
     */
    public val vpcOptions: Output<VpcEndpointVpcOptions>
        get() = javaResource.vpcOptions().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object VpcEndpointMapper : ResourceMapper<VpcEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.opensearch.VpcEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpoint = VpcEndpoint(
        javaResource as
            com.pulumi.aws.opensearch.VpcEndpoint,
    )
}

/**
 * @see [VpcEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpoint].
 */
public suspend fun vpcEndpoint(name: String, block: suspend VpcEndpointResourceBuilder.() -> Unit): VpcEndpoint {
    val builder = VpcEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpoint(name: String): VpcEndpoint {
    val builder = VpcEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
